/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.concurrent.Condition;

@Shared(scope={Shared.Scope.SIMULATION}, inner=Shared.Recursive.INTERFACES)
public interface WaitQueue {
    public Signal register();

    public <V> Signal register(V var1, Consumer<V> var2);

    public boolean signal();

    public void signalAll();

    public boolean hasWaiters();

    public int getWaiting();

    public static WaitQueue newWaitQueue() {
        return new Standard();
    }

    public static void waitOnCondition(BooleanSupplier condition, WaitQueue queue) throws InterruptedException {
        while (!condition.getAsBoolean()) {
            Signal s = queue.register();
            if (!condition.getAsBoolean()) {
                s.await();
                continue;
            }
            s.cancel();
        }
    }

    public static class Standard
    implements WaitQueue {
        private static final int CANCELLED = -1;
        private static final int SIGNALLED = 1;
        private static final int NOT_SET = 0;
        private static final AtomicIntegerFieldUpdater<RegisteredSignal> signalledUpdater = AtomicIntegerFieldUpdater.newUpdater(RegisteredSignal.class, "state");
        private final ConcurrentLinkedQueue<RegisteredSignal> queue = new ConcurrentLinkedQueue();

        protected Standard() {
        }

        @Override
        public Signal register() {
            RegisteredSignal signal = new RegisteredSignal();
            this.queue.add(signal);
            return signal;
        }

        @Override
        public <V> Signal register(V supplyOnDone, Consumer<V> receiveOnDone) {
            SignalWithListener signal = new SignalWithListener(supplyOnDone, receiveOnDone);
            this.queue.add(signal);
            return signal;
        }

        @Override
        public boolean signal() {
            RegisteredSignal s;
            while ((s = this.queue.poll()) != null && s.doSignal() == null) {
            }
            return s != null;
        }

        @Override
        public void signalAll() {
            if (!this.hasWaiters()) {
                return;
            }
            int i = 0;
            int s = 5;
            Thread randomThread = null;
            Iterator<RegisteredSignal> iter = this.queue.iterator();
            while (iter.hasNext()) {
                RegisteredSignal signal = iter.next();
                Thread signalled = signal.doSignal();
                if (signalled != null) {
                    if (signalled == randomThread) break;
                    if (++i == s) {
                        randomThread = signalled;
                        s <<= 1;
                    }
                }
                iter.remove();
            }
        }

        private void cleanUpCancelled() {
            this.queue.removeIf(RegisteredSignal::isCancelled);
        }

        @Override
        public boolean hasWaiters() {
            return !this.queue.isEmpty();
        }

        @Override
        public int getWaiting() {
            if (!this.hasWaiters()) {
                return 0;
            }
            Iterator<RegisteredSignal> iter = this.queue.iterator();
            int count = 0;
            while (iter.hasNext()) {
                Signal next = iter.next();
                if (next.isCancelled()) continue;
                ++count;
            }
            return count;
        }

        private final class SignalWithListener<V>
        extends RegisteredSignal {
            private final V supplyOnDone;
            private final Consumer<V> receiveOnDone;

            private SignalWithListener(V supplyOnDone, Consumer<V> receiveOnDone) {
                this.receiveOnDone = receiveOnDone;
                this.supplyOnDone = supplyOnDone;
            }

            @Override
            public boolean checkAndClear() {
                this.receiveOnDone.accept(this.supplyOnDone);
                return super.checkAndClear();
            }

            @Override
            public void cancel() {
                if (!this.isCancelled()) {
                    this.receiveOnDone.accept(this.supplyOnDone);
                    super.cancel();
                }
            }
        }

        private class RegisteredSignal
        extends AbstractSignal {
            private volatile Thread thread = Thread.currentThread();
            volatile int state;

            private RegisteredSignal() {
            }

            @Override
            public boolean isSignalled() {
                return this.state == 1;
            }

            @Override
            public boolean isCancelled() {
                return this.state == -1;
            }

            @Override
            public boolean isSet() {
                return this.state != 0;
            }

            private Thread doSignal() {
                if (!this.isSet() && signalledUpdater.compareAndSet(this, 0, 1)) {
                    Thread thread = this.thread;
                    LockSupport.unpark(thread);
                    this.thread = null;
                    return thread;
                }
                return null;
            }

            @Override
            public void signal() {
                this.doSignal();
            }

            @Override
            public boolean checkAndClear() {
                if (!this.isSet() && signalledUpdater.compareAndSet(this, 0, -1)) {
                    this.thread = null;
                    Standard.this.cleanUpCancelled();
                    return false;
                }
                return true;
            }

            @Override
            public void cancel() {
                if (this.isCancelled()) {
                    return;
                }
                if (!signalledUpdater.compareAndSet(this, 0, -1)) {
                    this.state = -1;
                    Standard.this.signal();
                }
                this.thread = null;
                Standard.this.cleanUpCancelled();
            }
        }

        public static abstract class AbstractSignal
        extends Awaitable.AbstractAwaitable
        implements Signal {
            @Override
            public Signal await() throws InterruptedException {
                while (!this.isSignalled()) {
                    this.checkInterrupted();
                    LockSupport.park();
                }
                this.checkAndClear();
                return this;
            }

            @Override
            public boolean awaitUntil(long nanoTimeDeadline) throws InterruptedException {
                long now;
                while (nanoTimeDeadline > (now = Clock.Global.nanoTime()) && !this.isSignalled()) {
                    this.checkInterrupted();
                    long delta = nanoTimeDeadline - now;
                    LockSupport.parkNanos(delta);
                }
                return this.checkAndClear();
            }

            private void checkInterrupted() throws InterruptedException {
                if (Thread.interrupted()) {
                    this.cancel();
                    throw new InterruptedException();
                }
            }
        }
    }

    public static interface Signal
    extends Condition {
        public boolean isCancelled();

        public boolean isSet();

        public boolean checkAndClear();

        public void cancel();
    }
}

