/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.ViaRequest;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ViaRequestTest {
    ViaRequestTest() {
    }

    @Test
    void testViaRequestGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setAuthority(new URIAuthority("somehost", 8888));
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        ViaRequest interceptor = new ViaRequest();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"Via", (Object)request.getHeader("Via").getName());
        Assertions.assertNotNull((Object)request.getHeader("Via"));
        Assertions.assertEquals((Object)"HTTP 1.1 somehost:8888", (Object)request.getHeader("Via").getValue());
    }

    @Test
    void testViaRequestGeneratedWithOutPort() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setAuthority(new URIAuthority("somehost"));
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        ViaRequest interceptor = new ViaRequest();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"Via", (Object)request.getHeader("Via").getName());
        Assertions.assertNotNull((Object)request.getHeader("Via"));
        Assertions.assertEquals((Object)"HTTP 1.1 somehost", (Object)request.getHeader("Via").getValue());
    }

    @Test
    void testViaRequestInvalidHttpVersion() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_0_9);
        request.setAuthority(new URIAuthority("somehost", 8888));
        HttpRequestInterceptor interceptor = ViaRequest.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testViaRequestInvalidAuthority() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpRequestInterceptor interceptor = ViaRequest.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testViaRequestNotCreatedAlreadyAdded() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setAuthority(new URIAuthority("somehost", 8888));
        String viaValue = "HTTP 1.1 host:8888";
        request.setHeader("Via", (Object)"HTTP 1.1 host:8888");
        ViaRequest interceptor = new ViaRequest();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"Via", (Object)request.getHeader("Via").getName());
        Assertions.assertNotNull((Object)request.getHeader("Via"));
        Assertions.assertEquals((Object)request.getHeader("Via").getValue(), (Object)"HTTP 1.1 host:8888");
    }
}

