/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.RowPartitionExtractor;
import org.apache.ignite.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.sql.ColumnType;

public class TablePartitionExtractor<RowT>
implements RowPartitionExtractor<RowT> {
    private final PartitionCalculator partitionCalculator;
    private final int[] fields;
    private final TableDescriptor tableDescriptor;
    private final RowHandler<RowT> rowHandler;

    public TablePartitionExtractor(PartitionCalculator partitionCalculator, int[] fields, TableDescriptor tableDescriptor, RowHandler<RowT> rowHandler) {
        this.partitionCalculator = partitionCalculator;
        this.fields = fields;
        this.tableDescriptor = tableDescriptor;
        this.rowHandler = rowHandler;
    }

    @Override
    public int partition(RowT row) {
        int[] colocationColumns = this.tableDescriptor.distribution().getKeys().toIntArray();
        for (int i = 0; i < this.fields.length; ++i) {
            Object value = this.rowHandler.get(this.fields[i], row);
            ColumnType type = this.tableDescriptor.columnDescriptor(colocationColumns[i]).physicalType().spec();
            value = value == null ? null : TypeUtils.fromInternal(value, type);
            this.partitionCalculator.append(value);
        }
        return this.partitionCalculator.partition();
    }
}

