"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.YardEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var React = __importStar(require("react"));
var react_1 = require("react");
var Drawer_1 = require("@patternfly/react-core/dist/js/components/Drawer");
var i18n_1 = require("../i18n");
var api_1 = require("@kie-tools-core/workspace/dist/api");
var YardTextEditorController_1 = require("../textEditor/YardTextEditorController");
var YardTextEditor_1 = require("../textEditor/YardTextEditor");
var api_2 = require("@kie-tools-core/editor/dist/api");
var react_components_1 = require("@kie-tools-core/i18n/dist/react-components");
var uiEditor_1 = require("../uiEditor");
require("./YardEditor.css");
var model_1 = require("../model");
var RefForwardingYardEditor = function (props, forwardedRef) {
    var _a = __read((0, react_1.useState)(undefined), 2), file = _a[0], setFile = _a[1];
    var _b = __read((0, react_1.useState)(), 2), yardData = _b[0], setYardData = _b[1];
    var yardTextEditorRef = (0, react_1.useRef)(null);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        return {
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, newContent) {
                try {
                    setFile({
                        content: newContent,
                        normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                    });
                    setYardData((0, model_1.deserialize)(newContent));
                    return Promise.resolve();
                }
                catch (e) {
                    console.error(e);
                    return Promise.reject();
                }
            },
            getContent: function () {
                var _a;
                return Promise.resolve(((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.getContent()) || "");
            },
            getPreview: function () {
                return Promise.resolve("");
            },
            undo: function () {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo()) || Promise.resolve();
            },
            redo: function () {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.redo()) || Promise.resolve();
            },
            validate: function () {
                return [];
            },
            setTheme: function (theme) {
                var _a;
                return ((_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.setTheme(theme)) || Promise.resolve();
            },
            moveCursorToPosition: function (position) {
                var _a;
                (_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.moveCursorToPosition(position);
            },
        };
    }, []);
    var setValidationErrors = (0, react_1.useCallback)(function (errors) {
        if (!file) {
            return;
        }
        var notifications = errors.map(function (error) { return ({
            type: "PROBLEM",
            normalizedPosixPathRelativeToTheWorkspaceRoot: file.normalizedPosixPathRelativeToTheWorkspaceRoot,
            severity: "ERROR",
            message: "".concat(error.message),
            position: {
                startLineNumber: error.startLineNumber,
                startColumn: error.startColumn,
                endLineNumber: error.endLineNumber,
                endColumn: error.endColumn,
            },
        }); });
        props.setNotifications.apply(file.normalizedPosixPathRelativeToTheWorkspaceRoot, notifications);
    }, [file, props.setNotifications]);
    var isVscode = (0, react_1.useCallback)(function () {
        return props.channelType === api_2.ChannelType.VSCODE_DESKTOP || props.channelType === api_2.ChannelType.VSCODE_WEB;
    }, [props.channelType]);
    var onContentChanged = (0, react_1.useCallback)(function (newContent, operation) {
        var _a, _b;
        switch (operation) {
            case YardTextEditorController_1.YardTextEditorOperation.EDIT:
                props.onNewEdit(new api_1.WorkspaceEdit(newContent));
                break;
            case YardTextEditorController_1.YardTextEditorOperation.UNDO:
                if (!isVscode()) {
                    (_a = yardTextEditorRef.current) === null || _a === void 0 ? void 0 : _a.undo();
                }
                props.onStateControlCommandUpdate(api_2.StateControlCommand.UNDO);
                break;
            case YardTextEditorController_1.YardTextEditorOperation.REDO:
                if (!isVscode()) {
                    (_b = yardTextEditorRef.current) === null || _b === void 0 ? void 0 : _b.redo();
                }
                props.onStateControlCommandUpdate(api_2.StateControlCommand.REDO);
                break;
        }
        setYardData((0, model_1.deserialize)(newContent));
    }, [props, isVscode]);
    var yardTextEditor = (0, react_1.useMemo)(function () {
        return file && ((0, jsx_runtime_1.jsx)(YardTextEditor_1.YardTextEditor, { channelType: props.channelType, file: file, onContentChange: onContentChanged, setValidationErrors: setValidationErrors, ref: yardTextEditorRef, isReadOnly: props.isReadOnly }));
    }, [file, props.channelType, onContentChanged, setValidationErrors, props.isReadOnly]);
    var yardUIContainer = (0, react_1.useMemo)(function () {
        return file && ((0, jsx_runtime_1.jsx)(react_components_1.I18nDictionariesProvider, __assign({ defaults: i18n_1.yardEditorI18nDefaults, dictionaries: i18n_1.yardEditorDictionaries, initialLocale: navigator.language, ctx: i18n_1.YardEditorI18nContext }, { children: (0, jsx_runtime_1.jsx)(uiEditor_1.YardUIEditor, { yardData: yardData, isReadOnly: props.isReadOnly }) })));
    }, [file, yardData, props.isReadOnly]);
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (isVscode() && yardUIContainer) || ((0, jsx_runtime_1.jsx)(Drawer_1.Drawer, __assign({ className: "yard-drawer", isExpanded: true, isInline: true }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContent, __assign({ panelContent: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelContent, __assign({ isResizable: true, defaultSize: "50%" }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelBody, { children: yardUIContainer }) })) }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContentBody, __assign({ className: "drawer-content-body" }, { children: yardTextEditor })) })) }))) }));
};
exports.YardEditor = React.forwardRef(RefForwardingYardEditor);
//# sourceMappingURL=YardEditor.js.map