var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback } from "react";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { EditableNodeLabel, useEditableNodeLabel } from "../diagram/nodes/EditableNodeLabel";
import { TypeRefLabel } from "./TypeRefLabel";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { renameItemDefinition } from "../mutations/renameItemDefinition";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
export function DataTypeName(_a) {
    var _b, _c;
    var isReadonly = _a.isReadonly, itemDefinition = _a.itemDefinition, isActive = _a.isActive, editMode = _a.editMode, relativeToNamespace = _a.relativeToNamespace, shouldCommitOnBlur = _a.shouldCommitOnBlur, onGetAllUniqueNames = _a.onGetAllUniqueNames, enableAutoFocusing = _a.enableAutoFocusing;
    var _d = useEditableNodeLabel((enableAutoFocusing !== null && enableAutoFocusing !== void 0 ? enableAutoFocusing : true) ? itemDefinition["@_id"] : undefined), isEditingLabel = _d.isEditingLabel, setEditingLabel = _d.setEditingLabel, triggerEditing = _d.triggerEditing, triggerEditingIfEnter = _d.triggerEditingIfEnter;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dataType = useDmnEditorStore(function (s) {
        return s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById.get(itemDefinition["@_id"]);
    });
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var feelQNameToDisplay = buildFeelQNameFromNamespace({
        namedElement: itemDefinition,
        importsByNamespace: importsByNamespace,
        namespace: dataType.namespace,
        relativeToNamespace: relativeToNamespace,
    });
    var onRenamed = useCallback(function (newName) {
        if (isReadonly) {
            return;
        }
        dmnEditorStoreApi.setState(function (state) {
            renameItemDefinition({
                definitions: state.dmn.model.definitions,
                newName: newName,
                itemDefinitionId: itemDefinition["@_id"],
                allDataTypesById: state.computed(state).getDataTypes(externalModelsByNamespace).allDataTypesById,
            });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, isReadonly, itemDefinition]);
    var _shouldCommitOnBlur = shouldCommitOnBlur !== null && shouldCommitOnBlur !== void 0 ? shouldCommitOnBlur : true;
    return (_jsxs(_Fragment, { children: [editMode === "hover" && (_jsx(InlineFeelNameInput, { isPlain: true, isReadonly: isReadonly, id: itemDefinition["@_id"], shouldCommitOnBlur: _shouldCommitOnBlur, name: feelQNameToDisplay.full, onRenamed: onRenamed, allUniqueNames: onGetAllUniqueNames, enableAutoFocusing: enableAutoFocusing })), editMode === "double-click" && (_jsxs(Flex, __assign({ tabIndex: -1, style: isEditingLabel ? { flexGrow: 1 } : {}, flexWrap: { default: "nowrap" }, spaceItems: { default: "spaceItemsNone" }, justifyContent: { default: "justifyContentFlexStart" }, alignItems: { default: "alignItemsCenter" }, onDoubleClick: triggerEditing, onKeyDown: triggerEditingIfEnter }, { children: [_jsx(EditableNodeLabel, { truncate: true, enableAutoFocusing: enableAutoFocusing, grow: true, isEditing: isEditingLabel, setEditing: setEditingLabel, onChange: onRenamed, shouldCommitOnBlur: shouldCommitOnBlur, value: itemDefinition["@_name"], position: "top-left", namedElement: itemDefinition, namedElementQName: {
                            type: "xml-qname",
                            localPart: itemDefinition["@_name"],
                            prefix: feelQNameToDisplay.prefix,
                        }, onGetAllUniqueNames: onGetAllUniqueNames }, itemDefinition["@_id"]), !isEditingLabel && (_jsx(TypeRefLabel, { typeRef: (_c = (_b = itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : DmnBuiltInDataType.Undefined, isCollection: itemDefinition["@_isCollection"], relativeToNamespace: relativeToNamespace }))] })))] }));
}
//# sourceMappingURL=DataTypeName.js.map