var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Stack, StackItem } from "@patternfly/react-core/layouts/Stack";
import React, { useCallback, useEffect, useRef, useState } from "react";
import { v4 as uuidv4 } from "uuid";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedFormDisplayer, FormOpenedState, FormSubmitResponseType, } from "@kie-tools/runtime-tools-shared-enveloped-components/dist/formDisplayer";
import { FormFooter } from "@kie-tools/runtime-tools-components/dist/components/FormFooter";
const CustomProcessFormDisplayer = ({ customForm, driver, targetOrigin, ouiaId, ouiaSafe, }) => {
    const formDisplayerApiRef = useRef(null);
    const [formUUID] = useState(uuidv4());
    const [formData] = useState({});
    const [formActions, setFormActions] = useState([]);
    const [formOpened, setFormOpened] = useState();
    const [submitted, setSubmitted] = useState(false);
    const doSubmit = useCallback((payload) => __awaiter(void 0, void 0, void 0, function* () {
        const formDisplayerApi = formDisplayerApiRef.current;
        try {
            const response = yield driver.startProcess(payload);
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.SUCCESS,
                info: response,
            });
        }
        catch (error) {
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.FAILURE,
                info: error,
            });
        }
        finally {
            setSubmitted(true);
        }
    }), [driver]);
    useEffect(() => {
        setFormActions([
            {
                name: "Start",
                execute: () => {
                    const formDisplayerApi = formDisplayerApiRef.current;
                    formDisplayerApi
                        .startSubmit({
                        params: {},
                    })
                        .then((formOutput) => doSubmit(formOutput))
                        .catch((error) => console.log(`Couldn't submit form due to: ${error}`));
                },
            },
        ]);
    }, [doSubmit]);
    return (React.createElement("div", Object.assign({}, componentOuiaProps(ouiaId, "custom-form-displayer", ouiaSafe), { style: { height: "100%" } }),
        React.createElement(Stack, { hasGutter: true },
            React.createElement(StackItem, { id: `${formUUID}-form`, style: { visibility: "visible", height: "inherit" } },
                React.createElement(EmbeddedFormDisplayer, { targetOrigin: targetOrigin, envelopePath: "resources/form-displayer.html", formContent: customForm, data: formData, context: {}, onOpenForm: (opened) => setFormOpened(opened), ref: formDisplayerApiRef })),
            formOpened && formOpened.state === FormOpenedState.OPENED && (React.createElement(StackItem, null,
                React.createElement(FormFooter, { actions: formActions, enabled: !submitted }))))));
};
export default CustomProcessFormDisplayer;
//# sourceMappingURL=CustomProcessFormDisplayer.js.map