import React, { useState } from "react";
import { Alert, AlertActionCloseButton, AlertActionLink } from "@patternfly/react-core/dist/js/components/Alert";
import { componentOuiaProps } from "../../ouiaTools";
export const FormNotification = ({ notification, ouiaId, ouiaSafe }) => {
    const variant = notification.type === "error" ? "danger" : "success";
    const [showDetails, setShowDetails] = useState(false);
    return (React.createElement(Alert, Object.assign({ isInline: true, title: notification.message, variant: variant, actionLinks: React.createElement(React.Fragment, null,
            notification.details && (React.createElement(AlertActionLink, { onClick: () => setShowDetails(!showDetails) }, "View details")),
            notification.customActions &&
                notification.customActions.length > 0 &&
                notification.customActions.map((customAction, index) => {
                    return (React.createElement(AlertActionLink, { onClick: customAction.onClick, key: index }, customAction.label));
                })), actionClose: React.createElement(AlertActionCloseButton, { onClose: notification.close }) }, componentOuiaProps(ouiaId, "form-notification-alert", ouiaSafe)), showDetails && notification.details && React.createElement("p", null, notification.details)));
};
//# sourceMappingURL=FormNotification.js.map