"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.associationModelFactory = exports.ASSOCIATION_MODEL = void 0;
var pmml4_4_1 = require("../../model/pmml4_4");
var LocalTransformations_1 = require("./LocalTransformations");
var MiningSchema_1 = require("./MiningSchema");
var ModelStats_1 = require("./ModelStats");
var ModelVerification_1 = require("./ModelVerification");
var Output_1 = require("./Output");
exports.ASSOCIATION_MODEL = "\nelements.elements[(name = \"AssociationModel\")] ~> $map(function($v, $i) {\n  $merge([\n    $associationModelFactory(),\n    $v.attributes,\n    {\n      \"_type\": $v.name\n    },\n    {\n      ".concat(MiningSchema_1.MINING_SCHEMA, ", \n      ").concat(Output_1.OUTPUT, ",\n      ").concat(ModelStats_1.MODEL_STATS, ",\n      ").concat(ModelVerification_1.MODEL_VERIFICATION, ",\n      ").concat(LocalTransformations_1.LOCAL_TRANSFORMATIONS, "\n    }\n  ])\n})");
function associationModelFactory() {
    return new pmml4_4_1.AssociationModel({
        MiningSchema: new pmml4_4_1.MiningSchema({ MiningField: [] }),
        functionName: "regression",
        numberOfTransactions: 0,
        minimumSupport: 0,
        minimumConfidence: 0,
        numberOfItems: 0,
        numberOfItemsets: 0,
        numberOfRules: 0,
    });
}
exports.associationModelFactory = associationModelFactory;
//# sourceMappingURL=AssociationModel.js.map