/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.util.ReadOnlyList;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;

class FSPermissionChecker
implements INodeAttributeProvider.AccessControlEnforcer {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final String fsOwner;
    private final String supergroup;
    private final UserGroupInformation callerUgi;
    private final String user;
    private final Set<String> groups;
    private final boolean isSuper;
    private final INodeAttributeProvider attributeProvider;

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access, FsPermission mode) {
        return this.toAccessControlString(inodeAttrib, path, access, mode, false);
    }

    private String toAccessControlString(INodeAttributes inodeAttrib, String path, FsAction access, FsPermission mode, boolean deniedFromAcl) {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.getUser()).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(path).append("\":").append(inodeAttrib.getUserName()).append(':').append(inodeAttrib.getGroupName()).append(':').append(inodeAttrib.isDirectory() ? (char)'d' : '-').append(mode);
        if (deniedFromAcl) {
            sb.append("+");
        }
        return sb.toString();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributeProvider attributeProvider) {
        this.fsOwner = fsOwner;
        this.supergroup = supergroup;
        this.callerUgi = callerUgi;
        HashSet<String> s = new HashSet<String>(Arrays.asList(callerUgi.getGroupNames()));
        this.groups = Collections.unmodifiableSet(s);
        this.user = callerUgi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
        this.attributeProvider = attributeProvider;
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public INodeAttributeProvider getAttributesProvider() {
        return this.attributeProvider;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuperUser()) {
            throw new AccessControlException("Access denied for user " + this.getUser() + ". Superuser privilege is required");
        }
    }

    void checkPermission(INodesInPath inodesInPath, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir));
        }
        int snapshotId = inodesInPath.getPathSnapshotId();
        INode[] inodes = inodesInPath.getINodesArray();
        INodeAttributes[] inodeAttrs = new INodeAttributes[inodes.length];
        byte[][] pathByNameArr = new byte[inodes.length][];
        for (int i = 0; i < inodes.length && inodes[i] != null; ++i) {
            if (inodes[i] == null) continue;
            pathByNameArr[i] = inodes[i].getLocalNameBytes();
            inodeAttrs[i] = this.getINodeAttrs(pathByNameArr, i, inodes[i], snapshotId);
        }
        String path = inodesInPath.getPath();
        int ancestorIndex = inodes.length - 2;
        INodeAttributeProvider.AccessControlEnforcer enforcer = this.getAttributesProvider().getExternalAccessControlEnforcer(this);
        enforcer.checkPermission(this.fsOwner, this.supergroup, this.callerUgi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
    }

    @Override
    public void checkPermission(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
        while (ancestorIndex >= 0 && inodes[ancestorIndex] == null) {
            --ancestorIndex;
        }
        this.checkTraverse(inodeAttrs, path, ancestorIndex);
        INodeAttributes last = inodeAttrs[inodeAttrs.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodeAttrs.length > 1 && last != null) {
            this.checkStickyBit(inodeAttrs[inodeAttrs.length - 2], last);
        }
        if (ancestorAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, path, ancestorIndex, ancestorAccess);
        }
        if (parentAccess != null && inodeAttrs.length > 1) {
            this.check(inodeAttrs, path, inodeAttrs.length - 2, parentAccess);
        }
        if (access != null) {
            this.check(last, path, access);
        }
        if (subAccess != null) {
            INode rawLast = inodes[inodeAttrs.length - 1];
            this.checkSubAccess(pathByNameArr, inodeAttrs.length - 1, rawLast, snapshotId, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(last);
        }
    }

    private INodeAttributes getINodeAttrs(byte[][] pathByNameArr, int pathIdx, INode inode, int snapshotId) {
        INodeAttributes inodeAttrs = inode.getSnapshotINode(snapshotId);
        if (this.getAttributesProvider() != null) {
            String[] elements = new String[pathIdx + 1];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = DFSUtil.bytes2String(pathByNameArr[i]);
            }
            inodeAttrs = this.getAttributesProvider().getAttributes(elements, inodeAttrs);
        }
        return inodeAttrs;
    }

    private void checkOwner(INodeAttributes inode) throws AccessControlException {
        if (this.getUser().equals(inode.getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied. user=" + this.getUser() + " is not the owner of inode=" + inode);
    }

    private void checkTraverse(INodeAttributes[] inodes, String path, int last) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], path, FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(byte[][] pathByNameArr, int pathIdx, INode inode, int snapshotId, FsAction access, boolean ignoreEmptyDir) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            ReadOnlyList<INode> cList = d.getChildrenList(snapshotId);
            if (!cList.isEmpty() || !ignoreEmptyDir) {
                this.check(this.getINodeAttrs(pathByNameArr, pathIdx, d, snapshotId), inode.getFullPathName(), access);
            }
            for (INode child : cList) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(INodeAttributes[] inodes, String path, int i, FsAction access) throws AccessControlException {
        this.check(i >= 0 ? inodes[i] : null, path, access);
    }

    private void check(INodeAttributes inode, String path, FsAction access) throws AccessControlException {
        int firstEntry;
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission();
        AclFeature aclFeature = inode.getAclFeature();
        if (aclFeature != null && AclEntryStatusFormat.getScope(firstEntry = aclFeature.getEntryAt(0)) == AclEntryScope.ACCESS) {
            this.checkAccessAcl(inode, path, access, mode, aclFeature);
            return;
        }
        if (this.getUser().equals(inode.getUserName()) ? mode.getUserAction().implies(access) : (this.getGroups().contains(inode.getGroupName()) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, path, access, mode));
    }

    private void checkAccessAcl(INodeAttributes inode, String path, FsAction access, FsPermission mode, AclFeature aclFeature) throws AccessControlException {
        boolean foundMatch = false;
        if (this.getUser().equals(inode.getUserName())) {
            if (mode.getUserAction().implies(access)) {
                return;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            int entry;
            for (int pos = 0; pos < aclFeature.getEntriesSize() && AclEntryStatusFormat.getScope(entry = aclFeature.getEntryAt(pos)) != AclEntryScope.DEFAULT; ++pos) {
                String group;
                AclEntryType type = AclEntryStatusFormat.getType(entry);
                String name = AclEntryStatusFormat.getName(entry);
                if (type == AclEntryType.USER) {
                    if (!this.getUser().equals(name)) continue;
                    FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP) continue;
                String string = group = name == null ? inode.getGroupName() : name;
                if (!this.getGroups().contains(group)) continue;
                FsAction masked = AclEntryStatusFormat.getPermission(entry).and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return;
                }
                foundMatch = true;
            }
        }
        if (!foundMatch && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, path, access, mode));
    }

    private void checkStickyBit(INodeAttributes parent, INodeAttributes inode) throws AccessControlException {
        if (!parent.getFsPermission().getStickyBit()) {
            return;
        }
        if (parent.getUserName().equals(this.getUser())) {
            return;
        }
        if (inode.getUserName().equals(this.getUser())) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + this.getUser() + ", inode=" + inode);
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.getUser().equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.getGroups().contains(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.getUser() + " does not have " + access.toString() + " permissions.");
    }
}

