/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core;

import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.ZoneId;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.persistence.BasePersistence;

public class PolarisCallContext
implements CallContext {
    private final BasePersistence metaStore;
    private final PolarisDiagnostics diagServices;
    private final PolarisConfigurationStore configurationStore;
    private final Clock clock;
    private RealmContext realmContext = null;

    public PolarisCallContext(@Nonnull RealmContext realmContext, @Nonnull BasePersistence metaStore, @Nonnull PolarisDiagnostics diagServices, @Nonnull PolarisConfigurationStore configurationStore, @Nonnull Clock clock) {
        this.realmContext = realmContext;
        this.metaStore = metaStore;
        this.diagServices = diagServices;
        this.configurationStore = configurationStore;
        this.clock = clock;
    }

    public PolarisCallContext(@Nonnull RealmContext realmContext, @Nonnull BasePersistence metaStore, @Nonnull PolarisDiagnostics diagServices) {
        this.realmContext = realmContext;
        this.metaStore = metaStore;
        this.diagServices = diagServices;
        this.configurationStore = new PolarisConfigurationStore(){};
        this.clock = Clock.system(ZoneId.systemDefault());
    }

    public BasePersistence getMetaStore() {
        return this.metaStore;
    }

    public PolarisDiagnostics getDiagServices() {
        return this.diagServices;
    }

    public PolarisConfigurationStore getConfigurationStore() {
        return this.configurationStore;
    }

    public Clock getClock() {
        return this.clock;
    }

    @Override
    public RealmContext getRealmContext() {
        return this.realmContext;
    }

    @Override
    public PolarisCallContext getPolarisCallContext() {
        return this;
    }

    @Override
    public PolarisCallContext copy() {
        String realmId = this.realmContext.getRealmIdentifier();
        RealmContext realmContext = () -> realmId;
        return new PolarisCallContext(realmContext, this.metaStore, this.diagServices, this.configurationStore, this.clock);
    }
}

