/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.AbstractMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.config.BehaviorChangeConfiguration;
import org.apache.polaris.core.config.FeatureConfiguration;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.persistence.cache.EntityCache;
import org.apache.polaris.core.persistence.cache.EntityCacheByNameKey;
import org.apache.polaris.core.persistence.cache.EntityCacheLookupResult;
import org.apache.polaris.core.persistence.cache.EntityCacheMode;
import org.apache.polaris.core.persistence.cache.EntityWeigher;
import org.apache.polaris.core.persistence.dao.entity.ResolvedEntityResult;

public class InMemoryEntityCache
implements EntityCache {
    private EntityCacheMode cacheMode;
    private final PolarisMetaStoreManager polarisMetaStoreManager;
    private final Cache<Long, ResolvedPolarisEntity> byId;
    private final AbstractMap<EntityCacheByNameKey, ResolvedPolarisEntity> byName = new ConcurrentHashMap<EntityCacheByNameKey, ResolvedPolarisEntity>();

    public InMemoryEntityCache(@Nonnull PolarisMetaStoreManager polarisMetaStoreManager) {
        RemovalListener removalListener = (key, value, cause) -> {
            if (value != null) {
                EntityCacheByNameKey nameKey = new EntityCacheByNameKey(value.getEntity());
                this.byName.remove(nameKey, value);
            }
        };
        long weigherTarget = PolarisConfiguration.loadConfig(FeatureConfiguration.ENTITY_CACHE_WEIGHER_TARGET);
        Caffeine byIdBuilder = Caffeine.newBuilder().maximumWeight(weigherTarget).weigher(EntityWeigher.asWeigher()).expireAfterAccess(1L, TimeUnit.HOURS).removalListener(removalListener);
        if (PolarisConfiguration.loadConfig(BehaviorChangeConfiguration.ENTITY_CACHE_SOFT_VALUES).booleanValue()) {
            byIdBuilder.softValues();
        }
        this.byId = byIdBuilder.build();
        this.polarisMetaStoreManager = polarisMetaStoreManager;
        this.cacheMode = EntityCacheMode.ENABLE;
    }

    @Override
    public void removeCacheEntry(@Nonnull ResolvedPolarisEntity cacheEntry) {
        EntityCacheByNameKey nameKey = new EntityCacheByNameKey(cacheEntry.getEntity());
        this.byId.asMap().remove(cacheEntry.getEntity().getId(), cacheEntry);
        this.byName.remove(nameKey, cacheEntry);
    }

    private void cacheNewEntry(@Nonnull ResolvedPolarisEntity cacheEntry) {
        EntityCacheByNameKey oldNameKey;
        EntityCacheByNameKey nameKey = new EntityCacheByNameKey(cacheEntry.getEntity());
        ResolvedPolarisEntity oldCacheEntry = (ResolvedPolarisEntity)this.byId.getIfPresent((Object)cacheEntry.getEntity().getId());
        this.byId.asMap().merge(cacheEntry.getEntity().getId(), cacheEntry, (oldValue, newValue) -> this.isNewer((ResolvedPolarisEntity)newValue, (ResolvedPolarisEntity)oldValue) ? newValue : oldValue);
        if (!cacheEntry.getEntity().isDropped()) {
            this.byName.put(nameKey, cacheEntry);
        }
        if (oldCacheEntry != null && !(oldNameKey = new EntityCacheByNameKey(oldCacheEntry.getEntity())).equals(nameKey)) {
            this.byName.remove(oldNameKey, oldCacheEntry);
        }
    }

    private boolean isNewer(ResolvedPolarisEntity newValue, ResolvedPolarisEntity oldValue) {
        return newValue.getEntity().getEntityVersion() > oldValue.getEntity().getEntityVersion() || newValue.getEntity().getGrantRecordsVersion() > oldValue.getEntity().getGrantRecordsVersion();
    }

    private void replaceCacheEntry(@Nullable ResolvedPolarisEntity oldCacheEntry, @Nonnull ResolvedPolarisEntity newCacheEntry) {
        if (oldCacheEntry != null) {
            if (this.entityNameKeyMismatch(oldCacheEntry.getEntity(), newCacheEntry.getEntity()) || oldCacheEntry.getEntity().getEntityVersion() < newCacheEntry.getEntity().getEntityVersion() || oldCacheEntry.getEntity().getGrantRecordsVersion() < newCacheEntry.getEntity().getGrantRecordsVersion()) {
                this.cacheNewEntry(newCacheEntry);
                this.removeCacheEntry(oldCacheEntry);
            }
        } else {
            this.cacheNewEntry(newCacheEntry);
        }
    }

    private boolean entityNameKeyMismatch(@Nonnull PolarisBaseEntity entity, @Nonnull PolarisBaseEntity otherEntity) {
        return entity.getId() != otherEntity.getId() || entity.getParentId() != otherEntity.getParentId() || !entity.getName().equals(otherEntity.getName()) || entity.getTypeCode() != otherEntity.getTypeCode();
    }

    public EntityCacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(EntityCacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Nullable
    public ResolvedPolarisEntity getEntityById(long entityId) {
        return (ResolvedPolarisEntity)this.byId.getIfPresent((Object)entityId);
    }

    @Nullable
    public ResolvedPolarisEntity getEntityByName(@Nonnull EntityCacheByNameKey entityNameKey) {
        return this.byName.get(entityNameKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ResolvedPolarisEntity getAndRefreshIfNeeded(@Nonnull PolarisCallContext callContext, @Nonnull PolarisBaseEntity entityToValidate, int entityMinVersion, int entityGrantRecordsMinVersion) {
        int grantRecordsVersion;
        List<PolarisGrantRecord> grantRecords;
        PolarisBaseEntity entity;
        long entityCatalogId = entityToValidate.getCatalogId();
        long entityId = entityToValidate.getId();
        PolarisEntityType entityType = entityToValidate.getType();
        ResolvedPolarisEntity existingCacheEntry = this.getEntityById(entityId);
        EntityCacheByNameKey nameKey = new EntityCacheByNameKey(entityToValidate);
        ResolvedPolarisEntity existingCacheEntryByName = this.getEntityByName(nameKey);
        if (existingCacheEntryByName != null && existingCacheEntry != null && this.isNewer(existingCacheEntry, existingCacheEntryByName)) {
            existingCacheEntry = existingCacheEntryByName;
        }
        if (existingCacheEntry != null && existingCacheEntry.getEntity().getEntityVersion() >= entityMinVersion) {
            if (existingCacheEntry.getEntity().getGrantRecordsVersion() >= entityGrantRecordsMinVersion) return existingCacheEntry;
        }
        if (existingCacheEntry == null) {
            ResolvedEntityResult refreshedCacheEntry = this.polarisMetaStoreManager.loadResolvedEntityById(callContext, entityCatalogId, entityId, entityType);
            if (!refreshedCacheEntry.isSuccess()) return null;
            entity = refreshedCacheEntry.getEntity();
            grantRecords = refreshedCacheEntry.getEntityGrantRecords();
            grantRecordsVersion = refreshedCacheEntry.getGrantRecordsVersion();
        } else {
            ResolvedEntityResult refreshedCacheEntry = this.polarisMetaStoreManager.refreshResolvedEntity(callContext, existingCacheEntry.getEntity().getEntityVersion(), existingCacheEntry.getEntity().getGrantRecordsVersion(), entityType, entityCatalogId, entityId);
            if (refreshedCacheEntry.isSuccess()) {
                PolarisBaseEntity polarisBaseEntity = entity = refreshedCacheEntry.getEntity() != null ? refreshedCacheEntry.getEntity() : existingCacheEntry.getEntity();
                if (refreshedCacheEntry.getEntityGrantRecords() != null) {
                    grantRecords = refreshedCacheEntry.getEntityGrantRecords();
                    grantRecordsVersion = refreshedCacheEntry.getGrantRecordsVersion();
                } else {
                    grantRecords = existingCacheEntry.getAllGrantRecords();
                    grantRecordsVersion = existingCacheEntry.getEntity().getGrantRecordsVersion();
                }
            } else {
                this.removeCacheEntry(existingCacheEntry);
                return null;
            }
        }
        callContext.getDiagServices().checkNotNull(entity, "unexpected_null_entity");
        callContext.getDiagServices().checkNotNull(grantRecords, "unexpected_null_grant_records");
        callContext.getDiagServices().check(grantRecordsVersion > 0, "unexpected_null_grant_records_version");
        ResolvedPolarisEntity newCacheEntry = new ResolvedPolarisEntity(callContext.getDiagServices(), entity, grantRecords, grantRecordsVersion);
        this.replaceCacheEntry(existingCacheEntry, newCacheEntry);
        return newCacheEntry;
    }

    @Override
    @Nullable
    public EntityCacheLookupResult getOrLoadEntityById(@Nonnull PolarisCallContext callContext, long entityCatalogId, long entityId, PolarisEntityType entityType) {
        boolean cacheHit;
        ResolvedPolarisEntity entry = this.getEntityById(entityId);
        if (entry == null) {
            cacheHit = false;
            ResolvedEntityResult result = this.polarisMetaStoreManager.loadResolvedEntityById(callContext, entityCatalogId, entityId, entityType);
            if (!result.isSuccess()) {
                return null;
            }
            callContext.getDiagServices().checkNotNull(result.getEntity(), "entity_should_loaded");
            callContext.getDiagServices().checkNotNull(result.getEntityGrantRecords(), "entity_grant_records_should_loaded");
            entry = new ResolvedPolarisEntity(callContext.getDiagServices(), result.getEntity(), result.getEntityGrantRecords(), result.getGrantRecordsVersion());
            this.cacheNewEntry(entry);
        } else {
            cacheHit = true;
        }
        return new EntityCacheLookupResult(entry, cacheHit);
    }

    @Override
    @Nullable
    public EntityCacheLookupResult getOrLoadEntityByName(@Nonnull PolarisCallContext callContext, @Nonnull EntityCacheByNameKey entityNameKey) {
        boolean cacheHit;
        ResolvedPolarisEntity entry = this.getEntityByName(entityNameKey);
        if (entry == null) {
            cacheHit = false;
            ResolvedEntityResult result = this.polarisMetaStoreManager.loadResolvedEntityByName(callContext, entityNameKey.getCatalogId(), entityNameKey.getParentId(), entityNameKey.getType(), entityNameKey.getName());
            if (!result.isSuccess()) {
                return null;
            }
            callContext.getDiagServices().checkNotNull(result.getEntity(), "entity_should_loaded");
            callContext.getDiagServices().checkNotNull(result.getEntityGrantRecords(), "entity_grant_records_should_loaded");
            entry = new ResolvedPolarisEntity(callContext.getDiagServices(), result.getEntity(), result.getEntityGrantRecords(), result.getGrantRecordsVersion());
            this.cacheNewEntry(entry);
        } else {
            cacheHit = true;
        }
        return new EntityCacheLookupResult(entry, cacheHit);
    }
}

