/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import io.smallrye.config.common.utils.StringUtil;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class EnvConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = -4525015934376795496L;
    public static final String NAME = "EnvConfigSource";
    public static final int ORDINAL = 300;
    private final EnvVars envVars;
    private final boolean hasProfiledName;

    protected EnvConfigSource() {
        this(300);
    }

    protected EnvConfigSource(int ordinal) {
        this(EnvConfigSource.getEnvProperties(), ordinal);
    }

    public EnvConfigSource(Map<String, String> properties, int ordinal) {
        super(NAME, EnvConfigSource.getEnvOrdinal(properties, ordinal));
        this.envVars = new EnvVars(properties);
        this.hasProfiledName = ConfigSourceUtil.hasProfiledName(this.getPropertyNames());
    }

    public Map<String, String> getProperties() {
        final HashMap<String, String> properties = new HashMap<String, String>();
        this.envVars.getEnv().forEach(new BiConsumer<EnvName, EnvEntry>(){

            @Override
            public void accept(EnvName key, EnvEntry entryValue) {
                if (entryValue.getEntries() != null) {
                    properties.putAll(entryValue.getEntries());
                } else {
                    properties.put(entryValue.getName(), entryValue.getValue());
                }
            }
        });
        return properties;
    }

    public Set<String> getPropertyNames() {
        return this.envVars.getNames();
    }

    public String getValue(String propertyName) {
        if (!this.hasProfiledName && !propertyName.isEmpty() && propertyName.charAt(0) == '%') {
            return null;
        }
        return this.envVars.get(propertyName);
    }

    boolean hasPropertyName(String propertyName) {
        return this.envVars.getEnv().containsKey(new EnvName(propertyName));
    }

    private static Map<String, String> getEnvProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return new HashMap<String, String>(System.getenv());
            }
        });
    }

    private static int getEnvOrdinal(Map<String, String> properties, int ordinal) {
        String value = properties.get("config_ordinal");
        if (value == null) {
            value = properties.get("config_ordinal".toUpperCase());
        }
        if (value != null) {
            return (Integer)Converters.INTEGER_CONVERTER.convert(value);
        }
        return ordinal;
    }

    Object writeReplace() {
        return new Ser();
    }

    static final class EnvVars
    implements Serializable {
        private static final long serialVersionUID = -56318356411229247L;
        private final Map<EnvName, EnvEntry> env;
        private final Set<String> names;

        public EnvVars(Map<String, String> properties) {
            this.env = new HashMap<EnvName, EnvEntry>(properties.size());
            this.names = new HashSet<String>(properties.size() * 2);
            properties.forEach(new BiConsumer<String, String>(){

                @Override
                public void accept(String key, String value) {
                    EnvName envName = new EnvName(key);
                    EnvEntry envEntry = env.get(envName);
                    if (envEntry == null) {
                        env.put(envName, new EnvEntry(key, value));
                    } else {
                        envEntry.add(key, value);
                    }
                    names.add(key);
                    names.add(StringUtil.toLowerCaseAndDotted((String)key));
                }
            });
        }

        public String get(String propertyName) {
            EnvEntry envEntry = this.env.get(new EnvName(propertyName));
            if (envEntry != null) {
                String value = envEntry.get();
                if (value != null) {
                    return value;
                }
                value = envEntry.getEntries().get(propertyName);
                if (value != null) {
                    return value;
                }
                String envName = StringUtil.replaceNonAlphanumericByUnderscores((String)propertyName);
                value = envEntry.getEntries().get(envName);
                if (value != null) {
                    return value;
                }
                return envEntry.envEntries.get(envName.toUpperCase());
            }
            return null;
        }

        public Map<EnvName, EnvEntry> getEnv() {
            return this.env;
        }

        public Set<String> getNames() {
            return this.names;
        }
    }

    static final class EnvName
    implements Serializable {
        private static final long serialVersionUID = -2679716955093904512L;
        private final String name;

        public EnvName(String name) {
            assert (name != null);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnvName that = (EnvName)o;
            return EnvName.equals(this.name, that.name);
        }

        public int hashCode() {
            int h = 0;
            int length = this.name.length();
            if (length >= 2 && this.name.charAt(length - 1) == '_' && this.name.charAt(length - 2) == '_') {
                --length;
            }
            for (int i = 0; i < length; ++i) {
                char c = this.name.charAt(i);
                if (i == 0 && length > 1 && (c == '%' || c == '_') && StringUtil.isAsciiLetterOrDigit((char)this.name.charAt(i + 1))) {
                    h = 31 * h + 31;
                    continue;
                }
                if (!StringUtil.isAsciiLetterOrDigit((char)c)) continue;
                h = 31 * h + Character.toLowerCase(c);
            }
            return h;
        }

        static boolean equals(String name, String other) {
            if (name == other) {
                return true;
            }
            if (name.isEmpty() && other.isEmpty()) {
                return true;
            }
            if (name.isEmpty() || other.isEmpty()) {
                return false;
            }
            int matchPosition = name.length() - 1;
            for (int i = other.length() - 1; i >= 0; --i) {
                if (matchPosition == -1) {
                    return false;
                }
                char o = other.charAt(i);
                char n = name.charAt(matchPosition);
                if (!(i != 0 || o != '%' && o != '_' || n != '%' && n != '_')) {
                    return true;
                }
                if (o == '.') {
                    if (n != '.' && n != '-' && n != '_' && n != '/') {
                        return false;
                    }
                } else if (o == '-') {
                    if (n != '.' && n != '-' && n != '_' && n != '/') {
                        return false;
                    }
                } else if (o == '\"') {
                    if (n != '\"' && n != '_') {
                        return false;
                    }
                    if (n == '_' && name.length() - 1 == matchPosition && (matchPosition = name.lastIndexOf("_", matchPosition - 1)) == -1) {
                        return false;
                    }
                } else {
                    if (o == ']') {
                        if (n != ']' && n != '_') {
                            return false;
                        }
                        int beginIndexed = other.lastIndexOf(91, i);
                        if (beginIndexed != -1) {
                            int range = i - beginIndexed - 1;
                            if ((name.lastIndexOf(95, matchPosition - 1) == matchPosition - range - 1 || name.lastIndexOf(91, matchPosition - 1) == matchPosition - range - 1) && StringUtil.isNumeric((CharSequence)other, (int)(beginIndexed + range), (int)i) && StringUtil.isNumeric((CharSequence)name, (int)(matchPosition - range), (int)matchPosition)) {
                                matchPosition = matchPosition - range - 2;
                                i = i - range - 1;
                                continue;
                            }
                        }
                        return false;
                    }
                    if (o == '_') {
                        if (StringUtil.isAsciiLetterOrDigit((char)n)) {
                            return false;
                        }
                        if (n == '\"' && other.length() - 1 == i && (i = other.lastIndexOf("_", i - 1)) == -1) {
                            return false;
                        }
                    } else if (!StringUtil.isAsciiLetterOrDigit((char)o) ? o != n && n != '_' : Character.toLowerCase(o) != Character.toLowerCase(n)) {
                        return false;
                    }
                }
                --matchPosition;
            }
            return matchPosition <= 0;
        }
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 6812312718645271331L;

        Ser() {
        }

        Object readResolve() {
            return new EnvConfigSource();
        }
    }

    static final class EnvEntry
    implements Serializable {
        private static final long serialVersionUID = -8786927401082731020L;
        private final String name;
        private final String value;
        private Map<String, String> envEntries;

        EnvEntry(String name, String value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        String get() {
            return this.envEntries == null ? this.value : null;
        }

        Map<String, String> getEntries() {
            return this.envEntries;
        }

        void add(String name, String value) {
            if (this.envEntries == null) {
                this.envEntries = new HashMap<String, String>();
                this.envEntries.put(this.name, this.value);
            }
            this.envEntries.put(name, value);
        }
    }
}

