/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.CountAggregate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.types.Types;

public class CountNonNull<T>
extends CountAggregate<T> {
    private final int fieldId;
    private final Types.NestedField field;

    protected CountNonNull(BoundTerm<T> term) {
        super(Expression.Operation.COUNT, term);
        this.field = term.ref().field();
        this.fieldId = this.field.fieldId();
    }

    @Override
    protected Long countFor(StructLike row) {
        return ((BoundTerm)this.term()).eval(row) != null ? 1L : 0L;
    }

    @Override
    protected boolean hasValue(DataFile file) {
        return this.safeContainsKey(file.valueCounts(), this.fieldId) && file.nullValueCounts().containsKey(this.fieldId);
    }

    @Override
    protected Long countFor(DataFile file) {
        return this.safeSubtract(this.safeGet(file.valueCounts(), this.fieldId), this.safeGet(file.nullValueCounts(), this.fieldId, 0L));
    }

    private Long safeSubtract(Long left, Long right) {
        if (left != null && right != null) {
            return left - right;
        }
        return null;
    }
}

