/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.Set;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.service.auth.ActiveRolesProvider;

@ApplicationScoped
public class ActiveRolesAugmentor
implements SecurityIdentityAugmentor {
    public static final int PRIORITY = 999;
    private final ActiveRolesProvider activeRolesProvider;

    @Inject
    public ActiveRolesAugmentor(ActiveRolesProvider activeRolesProvider) {
        this.activeRolesProvider = activeRolesProvider;
    }

    public int priority() {
        return 999;
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        return context.runBlocking(() -> this.validateActiveRoles(identity));
    }

    private SecurityIdentity validateActiveRoles(SecurityIdentity identity) {
        if (!(identity.getPrincipal() instanceof AuthenticatedPolarisPrincipal)) {
            throw new AuthenticationFailedException("No Polaris principal found");
        }
        AuthenticatedPolarisPrincipal polarisPrincipal = (AuthenticatedPolarisPrincipal)identity.getPrincipal(AuthenticatedPolarisPrincipal.class);
        Set validRoleNames = this.activeRolesProvider.getActiveRoles(polarisPrincipal);
        return QuarkusSecurityIdentity.builder().setAnonymous(false).setPrincipal((Principal)polarisPrincipal).addRoles(validRoleNames).addCredentials(identity.getCredentials()).addAttributes(identity.getAttributes()).addPermissionChecker(arg_0 -> ((SecurityIdentity)identity).checkPermission(arg_0)).build();
    }

    public ActiveRolesAugmentor() {
    }
}

