/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.auth.external.mapping;

import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.polaris.service.quarkus.auth.external.OidcTenantConfiguration;
import org.apache.polaris.service.quarkus.auth.external.OidcTenantResolvingAugmentor;
import org.apache.polaris.service.quarkus.auth.external.mapping.ClaimsLocator;
import org.apache.polaris.service.quarkus.auth.external.mapping.PrincipalMapper;
import org.eclipse.microprofile.jwt.JsonWebToken;

@ApplicationScoped
@Identifier(value="default")
class DefaultPrincipalMapper
implements PrincipalMapper {
    private final ClaimsLocator claimsLocator;

    @Inject
    public DefaultPrincipalMapper(ClaimsLocator claimsLocator) {
        this.claimsLocator = claimsLocator;
    }

    public OptionalLong mapPrincipalId(SecurityIdentity identity) {
        JsonWebToken jwt = (JsonWebToken)identity.getPrincipal();
        OidcTenantConfiguration.PrincipalMapper principalMapper = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity).principalMapper();
        return principalMapper.idClaimPath().map(claimPath -> this.claimsLocator.locateClaim(claimPath, jwt)).map(id -> id instanceof Number ? ((Number)id).longValue() : Long.parseLong(id.toString())).map(OptionalLong::of).orElse(OptionalLong.empty());
    }

    public Optional<String> mapPrincipalName(SecurityIdentity identity) {
        JsonWebToken jwt = (JsonWebToken)identity.getPrincipal();
        OidcTenantConfiguration.PrincipalMapper principalMapper = OidcTenantResolvingAugmentor.getOidcTenantConfig(identity).principalMapper();
        return principalMapper.nameClaimPath().map(claimPath -> this.claimsLocator.locateClaim(claimPath, jwt)).map(Object::toString);
    }

    public DefaultPrincipalMapper() {
    }
}

