/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.hadoop.hdfs.protocol.BlockType;

public class ReadStatistics {
    private long totalBytesRead;
    private long totalLocalBytesRead;
    private long totalShortCircuitBytesRead;
    private long totalZeroCopyBytesRead;
    private BlockType blockType = BlockType.CONTIGUOUS;
    private long totalEcDecodingTimeMillis;

    public ReadStatistics() {
        this.clear();
    }

    public ReadStatistics(ReadStatistics rhs) {
        this.totalBytesRead = rhs.getTotalBytesRead();
        this.totalLocalBytesRead = rhs.getTotalLocalBytesRead();
        this.totalShortCircuitBytesRead = rhs.getTotalShortCircuitBytesRead();
        this.totalZeroCopyBytesRead = rhs.getTotalZeroCopyBytesRead();
    }

    public synchronized long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public synchronized long getTotalLocalBytesRead() {
        return this.totalLocalBytesRead;
    }

    public synchronized long getTotalShortCircuitBytesRead() {
        return this.totalShortCircuitBytesRead;
    }

    public synchronized long getTotalZeroCopyBytesRead() {
        return this.totalZeroCopyBytesRead;
    }

    public synchronized long getRemoteBytesRead() {
        return this.totalBytesRead - this.totalLocalBytesRead;
    }

    public synchronized BlockType getBlockType() {
        return this.blockType;
    }

    public synchronized long getTotalEcDecodingTimeMillis() {
        return this.totalEcDecodingTimeMillis;
    }

    public synchronized void addRemoteBytes(long amt) {
        this.totalBytesRead += amt;
    }

    public synchronized void addLocalBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
    }

    public synchronized void addShortCircuitBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
        this.totalShortCircuitBytesRead += amt;
    }

    public synchronized void addZeroCopyBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
        this.totalShortCircuitBytesRead += amt;
        this.totalZeroCopyBytesRead += amt;
    }

    public synchronized void addErasureCodingDecodingTime(long millis) {
        this.totalEcDecodingTimeMillis += millis;
    }

    synchronized void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    public synchronized void clear() {
        this.totalBytesRead = 0L;
        this.totalLocalBytesRead = 0L;
        this.totalShortCircuitBytesRead = 0L;
        this.totalZeroCopyBytesRead = 0L;
        this.totalEcDecodingTimeMillis = 0L;
    }
}

