/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.BlobContainerItemProperties;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobContainerItem
implements XmlSerializable<BlobContainerItem> {
    private String name;
    private Boolean deleted;
    private String version;
    private BlobContainerItemProperties properties;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public BlobContainerItem setName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public BlobContainerItem setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public BlobContainerItem setVersion(String version) {
        this.version = version;
        return this;
    }

    public BlobContainerItemProperties getProperties() {
        return this.properties;
    }

    public BlobContainerItem setProperties(BlobContainerItemProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobContainerItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Container" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeXml((XmlSerializable)this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static BlobContainerItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobContainerItem.fromXml(xmlReader, null);
    }

    public static BlobContainerItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Container" : rootElementName;
        return (BlobContainerItem)xmlReader.readObject(finalRootElementName, reader -> {
            BlobContainerItem deserializedBlobContainerItem = new BlobContainerItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.name = reader.getStringElement();
                    continue;
                }
                if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.deleted = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.version = reader.getStringElement();
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedBlobContainerItem.properties = BlobContainerItemProperties.fromXml(reader, "Properties");
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedBlobContainerItem.metadata == null) {
                            deserializedBlobContainerItem.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedBlobContainerItem.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobContainerItem;
        });
    }
}

