/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.internal.StsAuthUtils;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithSamlResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public final class StsAssumeRoleWithSamlCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
    private static final String PROVIDER_NAME = BusinessMetricFeatureId.CREDENTIALS_STS_ASSUME_ROLE_SAML.value();
    private final Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier;
    private final String sourceChain;
    private final String providerName;

    private StsAssumeRoleWithSamlCredentialsProvider(Builder builder) {
        super(builder, "sts-assume-role-with-saml-credentials-provider");
        Validate.notNull((Object)builder.assumeRoleWithSamlRequestSupplier, (String)"Assume role with SAML request must not be null.", (Object[])new Object[0]);
        this.assumeRoleWithSamlRequestSupplier = builder.assumeRoleWithSamlRequestSupplier;
        this.sourceChain = builder.sourceChain;
        this.providerName = StringUtils.isEmpty((CharSequence)builder.sourceChain) ? PROVIDER_NAME : builder.sourceChain + "," + PROVIDER_NAME;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected AwsSessionCredentials getUpdatedCredentials(StsClient stsClient) {
        AssumeRoleWithSamlRequest assumeRoleWithSamlRequest = this.assumeRoleWithSamlRequestSupplier.get();
        Validate.notNull((Object)((Object)assumeRoleWithSamlRequest), (String)"Assume role with saml request must not be null.", (Object[])new Object[0]);
        AssumeRoleWithSamlResponse assumeRoleResponse = stsClient.assumeRoleWithSAML(assumeRoleWithSamlRequest);
        return StsAuthUtils.fromStsCredentials(assumeRoleResponse.credentials(), this.providerName(), StsAuthUtils.accountIdFromArn(assumeRoleResponse.assumedRoleUser()));
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    String providerName() {
        return this.providerName;
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsAssumeRoleWithSamlCredentialsProvider> {
        private Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier;
        private String sourceChain;

        private Builder() {
            super((B x$0) -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0));
        }

        public Builder(StsAssumeRoleWithSamlCredentialsProvider provider) {
            super(x$0 -> new StsAssumeRoleWithSamlCredentialsProvider((Builder)x$0), provider);
            this.assumeRoleWithSamlRequestSupplier = provider.assumeRoleWithSamlRequestSupplier;
            this.sourceChain = provider.sourceChain;
        }

        public Builder refreshRequest(AssumeRoleWithSamlRequest assumeRoleWithSamlRequest) {
            return this.refreshRequest(() -> assumeRoleWithSamlRequest);
        }

        public Builder refreshRequest(Supplier<AssumeRoleWithSamlRequest> assumeRoleWithSamlRequestSupplier) {
            this.assumeRoleWithSamlRequestSupplier = assumeRoleWithSamlRequestSupplier;
            return this;
        }

        public Builder refreshRequest(Consumer<AssumeRoleWithSamlRequest.Builder> assumeRoleWithSamlRequest) {
            return this.refreshRequest((AssumeRoleWithSamlRequest)((Object)((AssumeRoleWithSamlRequest.Builder)AssumeRoleWithSamlRequest.builder().applyMutation(assumeRoleWithSamlRequest)).build()));
        }

        public Builder sourceChain(String sourceChain) {
            this.sourceChain = sourceChain;
            return this;
        }

        @Override
        public StsAssumeRoleWithSamlCredentialsProvider build() {
            return (StsAssumeRoleWithSamlCredentialsProvider)super.build();
        }
    }
}

