/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.AnomalyDetector;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse;

public class ListLogAnomalyDetectorsPublisher
implements SdkPublisher<ListLogAnomalyDetectorsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListLogAnomalyDetectorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogAnomalyDetectorsPublisher(CloudWatchLogsAsyncClient client, ListLogAnomalyDetectorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogAnomalyDetectorsPublisher(CloudWatchLogsAsyncClient client, ListLogAnomalyDetectorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogAnomalyDetectorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogAnomalyDetectorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnomalyDetector> anomalyDetectors() {
        Function<ListLogAnomalyDetectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.anomalyDetectors() != null) {
                return response.anomalyDetectors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLogAnomalyDetectorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLogAnomalyDetectorsResponseFetcher
    implements AsyncPageFetcher<ListLogAnomalyDetectorsResponse> {
        private ListLogAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogAnomalyDetectorsResponse> nextPage(ListLogAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListLogAnomalyDetectorsPublisher.this.client.listLogAnomalyDetectors(ListLogAnomalyDetectorsPublisher.this.firstRequest);
            }
            return ListLogAnomalyDetectorsPublisher.this.client.listLogAnomalyDetectors((ListLogAnomalyDetectorsRequest)((Object)ListLogAnomalyDetectorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

