/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import io.airlift.airline.Accessor;
import io.airlift.airline.CommandFactory;
import io.airlift.airline.ParseException;
import io.airlift.airline.model.ArgumentsMetadata;
import io.airlift.airline.model.OptionMetadata;
import java.util.List;
import java.util.Map;

public final class ParserUtil {
    private ParserUtil() {
    }

    public static <T> T createInstance(Class<T> type) {
        if (type != null) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ParseException(e, "Unable to create instance %s", type.getName());
            }
        }
        return null;
    }

    public static <T> T createInstance(Class<?> type, Iterable<OptionMetadata> options, ListMultimap<OptionMetadata, Object> parsedOptions, ArgumentsMetadata arguments, Iterable<Object> parsedArguments, Iterable<Accessor> metadataInjection, Map<Class<?>, Object> bindings, CommandFactory<T> commandFactory) {
        T commandInstance = commandFactory.createInstance(type);
        return ParserUtil.injectOptions(commandInstance, options, parsedOptions, arguments, parsedArguments, metadataInjection, bindings);
    }

    public static <T> T injectOptions(T commandInstance, Iterable<OptionMetadata> options, ListMultimap<OptionMetadata, Object> parsedOptions, ArgumentsMetadata arguments, Iterable<Object> parsedArguments, Iterable<Accessor> metadataInjection, Map<Class<?>, Object> bindings) {
        for (OptionMetadata option : options) {
            List values = parsedOptions.get((Object)option);
            if (option.getArity() > 1 && values != null && !values.isEmpty()) {
                values = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)values));
            }
            if (values == null || values.isEmpty()) continue;
            for (Accessor accessor : option.getAccessors()) {
                accessor.addValues(commandInstance, values);
            }
        }
        if (arguments != null && parsedArguments != null) {
            for (Accessor accessor : arguments.getAccessors()) {
                accessor.addValues(commandInstance, parsedArguments);
            }
        }
        for (Accessor accessor : metadataInjection) {
            Object injectee = bindings.get(accessor.getJavaType());
            if (injectee == null) continue;
            accessor.addValues(commandInstance, (Iterable<?>)ImmutableList.of((Object)injectee));
        }
        return commandInstance;
    }
}

