/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowParameter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ModelInferenceDescriptor {
    private final TEndPoint targetAINode;
    private final ModelInformation modelInformation;
    private List<String> outputColumnNames;
    private InferenceWindowParameter inferenceWindowParameter;
    private Map<String, String> inferenceAttributes;

    public ModelInferenceDescriptor(TEndPoint targetAINode, ModelInformation modelInformation) {
        this.targetAINode = targetAINode;
        this.modelInformation = modelInformation;
    }

    private ModelInferenceDescriptor(ByteBuffer buffer) {
        this.targetAINode = new TEndPoint(ReadWriteIOUtils.readString((ByteBuffer)buffer), ReadWriteIOUtils.readInt((ByteBuffer)buffer));
        this.modelInformation = ModelInformation.deserialize((ByteBuffer)buffer);
        int outputColumnNamesSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (outputColumnNamesSize == 0) {
            this.outputColumnNames = null;
        } else {
            this.outputColumnNames = new ArrayList<String>();
            for (int i = 0; i < outputColumnNamesSize; ++i) {
                this.outputColumnNames.add(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
        }
        boolean hasInferenceWindowParameter = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.inferenceWindowParameter = hasInferenceWindowParameter ? InferenceWindowParameter.deserialize(buffer) : null;
        int inferenceAttributesSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        if (inferenceAttributesSize == 0) {
            this.inferenceAttributes = null;
        } else {
            this.inferenceAttributes = new HashMap<String, String>();
            for (int i = 0; i < inferenceAttributesSize; ++i) {
                this.inferenceAttributes.put(ReadWriteIOUtils.readString((ByteBuffer)buffer), ReadWriteIOUtils.readString((ByteBuffer)buffer));
            }
        }
    }

    public void setInferenceAttributes(Map<String, String> inferenceAttributes) {
        this.inferenceAttributes = inferenceAttributes;
    }

    public Map<String, String> getInferenceAttributes() {
        return this.inferenceAttributes;
    }

    public void setInferenceWindowParameter(InferenceWindowParameter inferenceWindowParameter) {
        this.inferenceWindowParameter = inferenceWindowParameter;
    }

    public InferenceWindowParameter getInferenceWindowParameter() {
        return this.inferenceWindowParameter;
    }

    public ModelInformation getModelInformation() {
        return this.modelInformation;
    }

    public TEndPoint getTargetAINode() {
        return this.targetAINode;
    }

    public String getModelName() {
        return this.modelInformation.getModelName();
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.targetAINode.ip, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.targetAINode.port, (ByteBuffer)byteBuffer);
        this.modelInformation.serialize(byteBuffer);
        if (this.outputColumnNames == null) {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (ByteBuffer)byteBuffer);
            for (String string : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)string, (ByteBuffer)byteBuffer);
            }
        }
        if (this.inferenceWindowParameter == null) {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            this.inferenceWindowParameter.serialize(byteBuffer);
        }
        if (this.inferenceAttributes == null) {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)this.inferenceAttributes.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry entry : this.inferenceAttributes.entrySet()) {
                ReadWriteIOUtils.write((String)((String)entry.getKey()), (ByteBuffer)byteBuffer);
                ReadWriteIOUtils.write((String)((String)entry.getValue()), (ByteBuffer)byteBuffer);
            }
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.targetAINode.ip, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.targetAINode.port, (OutputStream)stream);
        this.modelInformation.serialize(stream);
        if (this.outputColumnNames == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)this.outputColumnNames.size(), (OutputStream)stream);
            for (String string : this.outputColumnNames) {
                ReadWriteIOUtils.write((String)string, (OutputStream)stream);
            }
        }
        if (this.inferenceWindowParameter == null) {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.inferenceWindowParameter.serialize(stream);
        }
        if (this.inferenceAttributes == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)this.inferenceAttributes.size(), (OutputStream)stream);
            for (Map.Entry entry : this.inferenceAttributes.entrySet()) {
                ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)stream);
                ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)stream);
            }
        }
    }

    public static ModelInferenceDescriptor deserialize(ByteBuffer buffer) {
        return new ModelInferenceDescriptor(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelInferenceDescriptor that = (ModelInferenceDescriptor)o;
        return this.targetAINode.equals(that.targetAINode) && this.modelInformation.equals((Object)that.modelInformation) && this.outputColumnNames.equals(that.outputColumnNames) && this.inferenceWindowParameter.equals(that.inferenceWindowParameter) && this.inferenceAttributes.equals(that.inferenceAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.targetAINode, this.modelInformation, this.outputColumnNames, this.inferenceWindowParameter, this.inferenceAttributes);
    }
}

