/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryData
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=656");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=658");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=657");
    private final DataValue[] dataValues;

    public HistoryData(DataValue[] dataValues) {
        this.dataValues = dataValues;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DataValue[] getDataValues() {
        return this.dataValues;
    }

    protected HistoryData(HistoryDataBuilder<?, ?> b) {
        super(b);
        this.dataValues = ((HistoryDataBuilder)b).dataValues;
    }

    public static HistoryDataBuilder<?, ?> builder() {
        return new HistoryDataBuilderImpl();
    }

    public HistoryDataBuilder<?, ?> toBuilder() {
        return new HistoryDataBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryData)) {
            return false;
        }
        HistoryData other = (HistoryData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getDataValues(), other.getDataValues());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getDataValues());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryData(dataValues=" + Arrays.deepToString(this.getDataValues()) + ")";
    }

    private static final class HistoryDataBuilderImpl
    extends HistoryDataBuilder<HistoryData, HistoryDataBuilderImpl> {
        private HistoryDataBuilderImpl() {
        }

        @Override
        protected HistoryDataBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryData build() {
            return new HistoryData(this);
        }
    }

    public static abstract class HistoryDataBuilder<C extends HistoryData, B extends HistoryDataBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private DataValue[] dataValues;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryDataBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryData instance, HistoryDataBuilder<?, ?> b) {
            b.dataValues(instance.dataValues);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dataValues(DataValue[] dataValues) {
            this.dataValues = dataValues;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryData.HistoryDataBuilder(super=" + super.toString() + ", dataValues=" + Arrays.deepToString(this.dataValues) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryData> {
        @Override
        public Class<HistoryData> getType() {
            return HistoryData.class;
        }

        @Override
        public HistoryData decode(SerializationContext context, UaDecoder decoder) {
            DataValue[] dataValues = decoder.readDataValueArray("DataValues");
            return new HistoryData(dataValues);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryData value) {
            encoder.writeDataValueArray("DataValues", value.getDataValues());
        }
    }
}

