/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;

public class RegionMigrationPlan {
    private TConsensusGroupId regionId;
    private TDataNodeLocation fromDataNode;
    private TDataNodeLocation toDataNode;

    public RegionMigrationPlan(TConsensusGroupId regionId, TDataNodeLocation fromDataNode) {
        this.regionId = regionId;
        this.fromDataNode = fromDataNode;
        this.toDataNode = fromDataNode;
    }

    public static RegionMigrationPlan create(TConsensusGroupId regionId, TDataNodeLocation fromDataNode) {
        return new RegionMigrationPlan(regionId, fromDataNode);
    }

    public TConsensusGroupId getRegionId() {
        return this.regionId;
    }

    public TDataNodeLocation getFromDataNode() {
        return this.fromDataNode;
    }

    public TDataNodeLocation getToDataNode() {
        return this.toDataNode;
    }

    public void setToDataNode(TDataNodeLocation toDataNode) {
        this.toDataNode = toDataNode;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.regionId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.fromDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.toDataNode, (DataOutputStream)stream);
    }

    public static RegionMigrationPlan deserialize(ByteBuffer byteBuffer) {
        TConsensusGroupId regionId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
        TDataNodeLocation fromDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
        RegionMigrationPlan plan = RegionMigrationPlan.create(regionId, fromDataNode);
        plan.setToDataNode(ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer));
        return plan;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegionMigrationPlan that = (RegionMigrationPlan)obj;
        return this.regionId.equals(that.regionId) && this.fromDataNode.equals(that.fromDataNode) && this.toDataNode.equals(that.toDataNode);
    }

    public int hashCode() {
        return Objects.hash(this.regionId, this.fromDataNode, this.toDataNode);
    }

    public String toString() {
        return "RegionMigrationPlan{regionId=" + this.regionId + ", fromDataNode=" + this.fromDataNode + ", toDataNode=" + this.toDataNode + '}';
    }
}

