/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.BasicRoleManager;
import org.apache.iotdb.commons.auth.role.LocalFileRoleAccessor;
import org.apache.thrift.TException;

public class LocalFileRoleManager
extends BasicRoleManager {
    public LocalFileRoleManager(String roleDirPath) {
        super(new LocalFileRoleAccessor(roleDirPath));
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        this.accessor.cleanEntityFolder();
        for (Map.Entry entry : this.entityMap.entrySet()) {
            this.accessor.saveEntity((Role)entry.getValue());
        }
        return this.accessor.processTakeSnapshot(snapshotDir);
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.accessor.processLoadSnapshot(snapshotDir);
        try {
            super.reset();
        }
        catch (AuthException e) {
            throw new IOException(e);
        }
    }
}

