/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function.partition;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.iotdb.udf.api.relational.access.Record;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;

public class Slice {
    private final Column[] requiredColumns;
    private final Column[] passThroughColumns;
    private final List<Type> requiredDataTypes;
    private final long size;
    private final long estimatedSize;

    public Slice(int startIndex, int endIndex, Column[] columns, List<Integer> requiredChannels, List<Integer> passThroughChannels, List<Type> dataTypes) {
        this.size = endIndex - startIndex;
        List partitionColumns = Arrays.stream(columns).map(i -> i.getRegion(startIndex, (int)this.size)).collect(Collectors.toList());
        this.requiredColumns = (Column[])requiredChannels.stream().map(partitionColumns::get).toArray(Column[]::new);
        this.requiredDataTypes = requiredChannels.stream().map(dataTypes::get).collect(Collectors.toList());
        this.passThroughColumns = (Column[])passThroughChannels.stream().map(partitionColumns::get).toArray(Column[]::new);
        HashSet<Integer> channels = new HashSet<Integer>();
        channels.addAll(requiredChannels);
        channels.addAll(passThroughChannels);
        this.estimatedSize = channels.stream().map(i -> columns[i].getRetainedSizeInBytes()).reduce(0L, Long::sum);
    }

    public long getSize() {
        return this.size;
    }

    public Column[] getPassThroughResult(int[] indexes) {
        return (Column[])Arrays.stream(this.passThroughColumns).map(i -> i.getPositions(indexes, 0, indexes.length)).toArray(Column[]::new);
    }

    public Column[] getRequiredColumns() {
        return this.requiredColumns;
    }

    public Iterator<Record> getRequiredRecordIterator(boolean requireSnapshot) {
        if (!requireSnapshot) {
            return new Iterator<Record>(){
                private final RecordImpl record;
                {
                    this.record = new RecordImpl(-1, Slice.this.requiredColumns, Slice.this.requiredDataTypes);
                }

                @Override
                public boolean hasNext() {
                    this.record.offset++;
                    return (long)this.record.offset < Slice.this.size;
                }

                @Override
                public Record next() {
                    return this.record;
                }
            };
        }
        return new Iterator<Record>(){
            private int curIndex = 0;

            @Override
            public boolean hasNext() {
                return (long)this.curIndex < Slice.this.size;
            }

            @Override
            public Record next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int idx = this.curIndex++;
                return Slice.this.getRecord(idx, Slice.this.requiredColumns, Slice.this.requiredDataTypes);
            }
        };
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    private Record getRecord(int offset, Column[] originalColumns, List<Type> dataTypes) {
        return new RecordImpl(offset, originalColumns, dataTypes);
    }

    private static class RecordImpl
    implements Record {
        private int offset;
        private final Column[] originalColumns;
        private final List<Type> dataTypes;

        private RecordImpl(int offset, Column[] originalColumns, List<Type> dataTypes) {
            this.offset = offset;
            this.originalColumns = originalColumns;
            this.dataTypes = dataTypes;
        }

        public int getInt(int columnIndex) {
            return this.originalColumns[columnIndex].getInt(this.offset);
        }

        public long getLong(int columnIndex) {
            return this.originalColumns[columnIndex].getLong(this.offset);
        }

        public float getFloat(int columnIndex) {
            return this.originalColumns[columnIndex].getFloat(this.offset);
        }

        public double getDouble(int columnIndex) {
            return this.originalColumns[columnIndex].getDouble(this.offset);
        }

        public boolean getBoolean(int columnIndex) {
            return this.originalColumns[columnIndex].getBoolean(this.offset);
        }

        public Binary getBinary(int columnIndex) {
            return this.originalColumns[columnIndex].getBinary(this.offset);
        }

        public String getString(int columnIndex) {
            return this.originalColumns[columnIndex].getBinary(this.offset).getStringValue(TSFileConfig.STRING_CHARSET);
        }

        public LocalDate getLocalDate(int columnIndex) {
            return DateUtils.parseIntToLocalDate((int)this.originalColumns[columnIndex].getInt(this.offset));
        }

        public Object getObject(int columnIndex) {
            return this.originalColumns[columnIndex].getObject(this.offset);
        }

        public Type getDataType(int columnIndex) {
            return this.dataTypes.get(columnIndex);
        }

        public boolean isNull(int columnIndex) {
            return this.originalColumns[columnIndex].isNull(this.offset);
        }

        public int size() {
            return this.originalColumns.length;
        }
    }
}

