/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAnchor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrEmpty;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrExclusion;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantified;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;

public final class IrPatternAlternationOptimizer {
    private IrPatternAlternationOptimizer() {
    }

    public static IrRowPattern optimize(IrRowPattern node) {
        return (IrRowPattern)new Visitor().process(node);
    }

    private static class Visitor
    extends IrRowPatternVisitor<IrRowPattern, Void> {
        private Visitor() {
        }

        @Override
        protected IrRowPattern visitIrRowPattern(IrRowPattern node, Void context) {
            throw new UnsupportedOperationException("unsupported node type: " + node.getClass().getName());
        }

        @Override
        protected IrRowPattern visitIrLabel(IrLabel node, Void context) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrAnchor(IrAnchor node, Void context) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrEmpty(IrEmpty node, Void context) {
            return node;
        }

        @Override
        protected IrRowPattern visitIrExclusion(IrExclusion node, Void context) {
            IrRowPattern child = (IrRowPattern)this.process(node.getPattern());
            return new IrExclusion(child);
        }

        @Override
        protected IrRowPattern visitIrAlternation(IrAlternation node, Void context) {
            List children = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
            int emptyChildIndex = -1;
            for (int i = 0; i < children.size(); ++i) {
                if (!(children.get(i) instanceof IrEmpty)) continue;
                Preconditions.checkState((emptyChildIndex < 0 ? 1 : 0) != 0, (Object)"run IrRowPatternFlattener first to remove redundant empty pattern");
                emptyChildIndex = i;
            }
            if (emptyChildIndex < 0) {
                return new IrAlternation(children);
            }
            if (emptyChildIndex == 0) {
                IrQuantified child = new IrQuantified((IrRowPattern)children.get(1), IrQuantifier.zeroOrOne(false));
                if (children.size() == 2) {
                    return child;
                }
                ImmutableList.Builder builder = ImmutableList.builder().add((Object)child).addAll(children.subList(2, children.size()));
                return new IrAlternation((List<IrRowPattern>)builder.build());
            }
            children = ImmutableList.builder().addAll(children.subList(0, emptyChildIndex - 1)).add((Object)new IrQuantified((IrRowPattern)children.get(emptyChildIndex - 1), IrQuantifier.zeroOrOne(true))).addAll(children.subList(emptyChildIndex + 1, children.size())).build();
            if (children.size() == 1) {
                return (IrRowPattern)children.get(0);
            }
            return new IrAlternation(children);
        }

        @Override
        protected IrRowPattern visitIrConcatenation(IrConcatenation node, Void context) {
            List children = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
            return new IrConcatenation(children);
        }

        @Override
        protected IrRowPattern visitIrPermutation(IrPermutation node, Void context) {
            List children = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
            return new IrPermutation(children);
        }

        @Override
        protected IrRowPattern visitIrQuantified(IrQuantified node, Void context) {
            IrRowPattern child = (IrRowPattern)this.process(node.getPattern());
            return new IrQuantified(child, node.getQuantifier());
        }
    }
}

