/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime;

import java.util.Optional;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.deletion.PipeDeleteDataNodeEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeRemainingEventAndTimeOperator;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner.PipeTsFileEpochProgressIndexKeeper;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionHybridSource
extends PipeRealtimeDataRegionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionHybridSource.class);

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        EnrichedEvent eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
        } else if (eventToExtract instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else if (eventToExtract instanceof PipeDeleteDataNodeEvent) {
            this.extractDirectly(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return this.shouldExtractInsertion;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return this.shouldExtractInsertion;
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        if (this.canNotUseTabletAnymore(event)) {
            event.getTsFileEpoch().migrateState(this, curState -> TsFileEpoch.State.USING_TSFILE);
            PipeTsFileEpochProgressIndexKeeper.getInstance().registerProgressIndex(this.dataRegionId, this.pipeName, event.getTsFileEpoch().getResource());
        } else {
            event.getTsFileEpoch().migrateState(this, curState -> {
                switch (curState) {
                    case USING_TSFILE: 
                    case USING_BOTH: {
                        return TsFileEpoch.State.USING_BOTH;
                    }
                }
                return TsFileEpoch.State.USING_TABLET;
            });
        }
        TsFileEpoch.State state = event.getTsFileEpoch().getState(this);
        switch (state) {
            case USING_TSFILE: {
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName(), false);
                break;
            }
            case EMPTY: 
            case USING_TABLET: 
            case USING_BOTH: {
                if (state == TsFileEpoch.State.USING_BOTH) {
                    event.skipReportOnCommit();
                }
                if (this.pendingQueue.waitedOffer((Event)event)) break;
                String errorMessage = String.format("extractTabletInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName(), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state, PipeRealtimeDataRegionHybridSource.class.getName()}));
            }
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            switch (state) {
                case EMPTY: {
                    return ((PipeTsFileInsertionEvent)event.getEvent()).isLoaded() ? TsFileEpoch.State.USING_TSFILE : TsFileEpoch.State.USING_TABLET;
                }
                case USING_TABLET: {
                    return TsFileEpoch.State.USING_TABLET;
                }
                case USING_TSFILE: {
                    return TsFileEpoch.State.USING_TSFILE;
                }
            }
            return this.canNotUseTabletAnymore(event) ? TsFileEpoch.State.USING_TSFILE : TsFileEpoch.State.USING_BOTH;
        });
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TABLET: {
                PipeTsFileEpochProgressIndexKeeper.getInstance().eliminateProgressIndex(this.dataRegionId, this.pipeName, event.getTsFileEpoch().getFilePath());
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName(), false);
                return;
            }
            case USING_TSFILE: 
            case EMPTY: 
            case USING_BOTH: {
                if (this.pendingQueue.waitedOffer((Event)event)) break;
                String errorMessage = String.format("extractTsFileInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard TsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName(), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state2, PipeRealtimeDataRegionHybridSource.class.getName()}));
            }
        }
    }

    private boolean canNotUseTabletAnymore(PipeRealtimeEvent event) {
        long totalFloatingMemorySizeInBytes;
        long pipeCount;
        boolean mayInsertNodeMemoryReachDangerousThreshold;
        long floatingMemoryUsageInByte = PipeDataNodeAgent.task().getFloatingMemoryUsageInByte(this.pipeName);
        boolean bl = mayInsertNodeMemoryReachDangerousThreshold = floatingMemoryUsageInByte * (pipeCount = (long)PipeDataNodeAgent.task().getPipeCount()) >= (totalFloatingMemorySizeInBytes = PipeDataNodeResourceManager.memory().getTotalFloatingMemorySizeInBytes());
        if (mayInsertNodeMemoryReachDangerousThreshold && event.mayExtractorUseTablets(this)) {
            PipeDataNodeRemainingEventAndTimeOperator operator = PipeDataNodeSinglePipeMetrics.getInstance().remainingEventAndTimeOperatorMap.get(this.pipeID);
            LOGGER.info("Pipe task {}@{} canNotUseTabletAnyMore for tsFile {}: The memory usage of the insert node {} has reached the dangerous threshold of single pipe {}, event count: {}", new Object[]{this.pipeName, this.dataRegionId, event.getTsFileEpoch().getFilePath(), floatingMemoryUsageInByte, totalFloatingMemorySizeInBytes / pipeCount, Optional.ofNullable(operator).map(PipeDataNodeRemainingEventAndTimeOperator::getInsertNodeEventCount).orElse(0)});
        }
        return mayInsertNodeMemoryReachDangerousThreshold;
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent;
            EnrichedEvent eventToSupply = realtimeEvent.getEvent();
            if (eventToSupply instanceof TabletInsertionEvent) {
                suppliedEvent = this.supplyTabletInsertion(realtimeEvent);
            } else if (eventToSupply instanceof TsFileInsertionEvent) {
                suppliedEvent = this.supplyTsFileInsertion(realtimeEvent);
            } else if (eventToSupply instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else if (eventToSupply instanceof PipeDeleteDataNodeEvent || eventToSupply instanceof ProgressReportEvent) {
                suppliedEvent = this.supplyDirectly(realtimeEvent);
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s to supply.", eventToSupply.getClass(), this));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName(), false);
            if (suppliedEvent != null) {
                this.maySkipIndex4Event(realtimeEvent);
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    private Event supplyTabletInsertion(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName())) {
            return event.getEvent();
        }
        event.getTsFileEpoch().migrateState(this, s -> TsFileEpoch.State.USING_BOTH);
        LOGGER.warn("Discard tablet event {} because it is not reliable anymore. Change the state of TsFileEpoch to USING_BOTH.", (Object)event);
        return null;
    }

    private Event supplyTsFileInsertion(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridSource.class.getName())) {
            return event.getEvent();
        }
        String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
        LOGGER.error(errorMessage);
        PipeDataNodeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
        PipeTsFileEpochProgressIndexKeeper.getInstance().eliminateProgressIndex(this.dataRegionId, this.pipeName, event.getTsFileEpoch().getFilePath());
        return null;
    }
}

