/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSender;
import org.apache.iotdb.common.rpc.thrift.TServiceProvider;
import org.apache.iotdb.common.rpc.thrift.TServiceType;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResp;
import org.apache.iotdb.common.rpc.thrift.TTestConnectionResult;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class TestConnectionTask
implements IConfigTask {
    private final boolean needDetails;

    public TestConnectionTask(boolean needDetails) {
        this.needDetails = needDetails;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.testConnection(this.needDetails);
    }

    public static void buildTSBlock(TTestConnectionResp resp, int configNodeNum, int dataNodeNum, boolean needDetails, SettableFuture<ConfigTaskResult> future) {
        TestConnectionTask.sortTestConnectionResp(resp);
        if (!needDetails) {
            int expectNum;
            Map<TServiceType, Integer> expectedNumMap = TestConnectionTask.calculateExpectedResultNum(configNodeNum, dataNodeNum);
            ArrayList<TTestConnectionResult> newResultList = new ArrayList<TTestConnectionResult>();
            for (int i = 0; i < resp.getResultListSize(); i += expectNum) {
                TTestConnectionResult result = (TTestConnectionResult)resp.getResultList().get(i);
                expectNum = expectedNumMap.get(result.getServiceProvider().getServiceType());
                boolean allSameServiceProviderAllUp = resp.getResultList().stream().skip(i).limit(expectNum).allMatch(result1 -> result.getServiceProvider().equals(result1.serviceProvider) && result1.isSuccess());
                if (allSameServiceProviderAllUp) {
                    TTestConnectionResult allUpResult = new TTestConnectionResult(result);
                    allUpResult.setSender(new TSender());
                    newResultList.add(allUpResult);
                    continue;
                }
                newResultList.addAll(resp.getResultList().stream().skip(i).limit(expectNum).filter(result1 -> !result1.isSuccess()).collect(Collectors.toList()));
            }
            resp.setResultList(newResultList);
        }
        List outputDataTypes = ColumnHeaderConstant.testConnectionColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        int serviceProviderMaxLen = TestConnectionTask.calculateServiceProviderMaxLen(resp);
        int connectionMaxLen = TestConnectionTask.calculateConnectionMaxLen(resp);
        for (TTestConnectionResult result : resp.getResultList()) {
            String senderStr;
            builder.getTimeColumnBuilder().writeLong(0L);
            StringBuilder serviceStr = new StringBuilder(TestConnectionTask.serviceProviderToString(result.getServiceProvider()));
            while (serviceStr.length() < serviceProviderMaxLen) {
                serviceStr.append(" ");
            }
            builder.getColumnBuilder(0).writeBinary(new Binary(serviceStr.toString(), TSFileConfig.STRING_CHARSET));
            if (result.getSender().isSetConfigNodeLocation()) {
                senderStr = TestConnectionTask.endPointToString(result.getSender().getConfigNodeLocation().getInternalEndPoint());
                senderStr = senderStr + " (ConfigNode)";
            } else if (result.getSender().isSetDataNodeLocation()) {
                senderStr = TestConnectionTask.endPointToString(result.getSender().getDataNodeLocation().getInternalEndPoint());
                senderStr = senderStr + " (DataNode)";
            } else {
                senderStr = "All";
            }
            builder.getColumnBuilder(1).writeBinary(new Binary(senderStr, TSFileConfig.STRING_CHARSET));
            StringBuilder connectionStatus = new StringBuilder(TestConnectionTask.connectionResultToString(result));
            while (connectionStatus.length() < connectionMaxLen) {
                connectionStatus.append(" ");
            }
            builder.getColumnBuilder(2).writeBinary(new Binary(connectionStatus.toString(), TSFileConfig.STRING_CHARSET));
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), DatasetHeaderFactory.getTestConnectionHeader()));
    }

    private static Map<TServiceType, Integer> calculateExpectedResultNum(int configNodeNum, int dataNodeNum) {
        HashMap<TServiceType, Integer> result = new HashMap<TServiceType, Integer>();
        result.put(TServiceType.ConfigNodeInternalService, configNodeNum + dataNodeNum);
        result.put(TServiceType.DataNodeInternalService, configNodeNum + dataNodeNum);
        result.put(TServiceType.DataNodeMPPService, dataNodeNum);
        result.put(TServiceType.DataNodeExternalService, dataNodeNum);
        return result;
    }

    private static String serviceProviderToString(TServiceProvider provider) {
        String serviceStr = TestConnectionTask.endPointToString(provider.getEndPoint());
        serviceStr = serviceStr + " (" + provider.getServiceType() + ")";
        return serviceStr;
    }

    private static String connectionResultToString(TTestConnectionResult result) {
        if (result.isSuccess()) {
            return "UP";
        }
        return "DOWN (" + result.getReason() + ")";
    }

    private static String endPointToString(TEndPoint endPoint) {
        return endPoint.getIp() + ":" + endPoint.getPort();
    }

    private static void sortTestConnectionResp(TTestConnectionResp origin) {
        origin.getResultList().sort((o1, o2) -> {
            int servicePort2;
            String serviceIp2;
            String serviceIp1 = o1.getServiceProvider().getEndPoint().getIp();
            if (!serviceIp1.equals(serviceIp2 = o2.getServiceProvider().getEndPoint().getIp())) {
                return serviceIp1.compareTo(serviceIp2);
            }
            int servicePort1 = o1.getServiceProvider().getEndPoint().getPort();
            if (servicePort1 != (servicePort2 = o2.getServiceProvider().getEndPoint().getPort())) {
                return Integer.compare(servicePort1, servicePort2);
            }
            return 0;
        });
    }

    private static int calculateServiceProviderMaxLen(TTestConnectionResp resp) {
        return resp.getResultList().stream().map(TTestConnectionResult::getServiceProvider).map(TestConnectionTask::serviceProviderToString).mapToInt(String::length).max().getAsInt();
    }

    private static int calculateConnectionMaxLen(TTestConnectionResp resp) {
        return resp.getResultList().stream().map(TestConnectionTask::connectionResultToString).mapToInt(String::length).max().getAsInt();
    }
}

