/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.UUID;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.jmap.http.UserProvisioning$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0003H\u0001\u0011\u0005\u0001\nC\u0003`\u0001\u0011%\u0001\rC\u0003c\u0001\u0011%1\rC\u0003l\u0001\u0011%A\u000eC\u0003s\u0001\u0011%1o\u0002\u0005\u0000\u001f\u0005\u0005\t\u0012AA\u0001\r!qq\"!A\t\u0002\u0005\r\u0001BB\u001c\f\t\u0003\t)\u0001C\u0005\u0002\b-\t\n\u0011\"\u0001\u0002\n\t\u0001Rk]3s!J|g/[:j_:Lgn\u001a\u0006\u0003!E\tA\u0001\u001b;ua*\u0011!cE\u0001\u0005U6\f\u0007O\u0003\u0002\u0015+\u0005)!.Y7fg*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003=)8/\u001a:t%\u0016\u0004xn]5u_JL\bCA\u0012)\u001b\u0005!#BA\u0013'\u0003\r\t\u0007/\u001b\u0006\u0003OM\tA!^:fe&\u0011\u0011\u0006\n\u0002\u0010+N,'o\u001d*fa>\u001c\u0018\u000e^8ss\u0006iQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\"\u0001\f\u0019\u000e\u00035R!!\n\u0018\u000b\u0005=\u001a\u0012aB7fiJL7m]\u0005\u0003c5\u0012Q\"T3ue&\u001cg)Y2u_JL\u0018!\u00056nCB\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011A'N\u0007\u0002#%\u0011a'\u0005\u0002\u0012\u00156\u000b\u0005kQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0003:wqj\u0004C\u0001\u001e\u0001\u001b\u0005y\u0001\"B\u0011\u0005\u0001\u0004\u0011\u0003\"\u0002\u0016\u0005\u0001\u0004Y\u0003b\u0002\u001a\u0005!\u0003\u0005\ra\r\u0015\u0003\t}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\r%t'.Z2u\u0015\u0005!\u0015a\u00026bW\u0006\u0014H/Y\u0005\u0003\r\u0006\u0013a!\u00138kK\u000e$\u0018!\u00049s_ZL7/[8o+N,'\u000f\u0006\u0002J/B\u0019!J\u0015+\u000e\u0003-S!\u0001T'\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u0010O\u0015\ty\u0005+\u0001\u0003d_J,'\"A)\u0002\u000fI,\u0017m\u0019;pe&\u00111k\u0013\u0002\u0006'6{gn\u001c\t\u00039UK!AV\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u00061\u0016\u0001\r!W\u0001\bg\u0016\u001c8/[8o!\tQV,D\u0001\\\u0015\ta6#A\u0004nC&d'm\u001c=\n\u0005y[&AD'bS2\u0014w\u000e_*fgNLwN\\\u0001\u0016GJ,\u0017\r^3BG\u000e|WO\u001c;JM:+W\rZ3e)\tI\u0015\rC\u0003Y\r\u0001\u0007\u0011,A\u0007de\u0016\fG/Z!dG>,h\u000e\u001e\u000b\u0003\u0013\u0012DQ!Z\u0004A\u0002\u0019\f\u0001\"^:fe:\fW.\u001a\t\u0003O&l\u0011\u0001\u001b\u0006\u0003\u001fNI!A\u001b5\u0003\u0011U\u001bXM\u001d8b[\u0016\fAC\\3fIN\f5mY8v]R\u001c%/Z1uS>tGCA7r!\rQ%K\u001c\t\u00039=L!\u0001]\u000f\u0003\u000f\t{w\u000e\\3b]\")Q\r\u0003a\u0001M\u0006\u0001r-\u001a8fe\u0006$X\rU1tg^|'\u000fZ\u000b\u0002iB\u0011Q\u000f \b\u0003mj\u0004\"a^\u000f\u000e\u0003aT!!_\r\u0002\rq\u0012xn\u001c;?\u0013\tYX$\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>\u001e\u0003A)6/\u001a:Qe>4\u0018n]5p]&tw\r\u0005\u0002;\u0017M\u00111b\u0007\u000b\u0003\u0003\u0003\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u0006U\r\u0019\u0014QB\u0016\u0003\u0003\u001f\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011D\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0005M!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class UserProvisioning {
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;
    private final JMAPConfiguration jmapConfiguration;

    public static JMAPConfiguration $lessinit$greater$default$3() {
        return UserProvisioning$.MODULE$.$lessinit$greater$default$3();
    }

    public SMono<BoxedUnit> provisionUser(MailboxSession session) {
        if (session != null && !this.usersRepository.isReadOnly() && this.jmapConfiguration.isUserProvisioningEnabled()) {
            return this.createAccountIfNeeded(session);
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<BoxedUnit> createAccountIfNeeded(MailboxSession session) {
        return SMono$.MODULE$.apply(this.metricFactory.decoratePublisherWithTimerMetric("JMAP-RFC-8621-user-provisioning", (Publisher)this.needsAccountCreation(session.getUser()).filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)b))).flatMap((Function1 & Serializable)x$1 -> this.createAccount(session.getUser())).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof AlreadyExistInUsersRepositoryException) {
                return SMono$.MODULE$.empty();
            }
            return SMono$.MODULE$.error(throwable);
        })));
    }

    private SMono<BoxedUnit> createAccount(Username username) {
        return SMono$.MODULE$.fromCallable(() -> {
            this.usersRepository.addUser(username, this.generatePassword());
            return BoxedUnit.UNIT;
        }).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    private SMono<Object> needsAccountCreation(Username username) {
        return SMono$.MODULE$.apply(this.usersRepository.containsReactive(username)).map((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)UserProvisioning.$anonfun$needsAccountCreation$1(b)));
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }

    public static final /* synthetic */ boolean $anonfun$needsAccountCreation$1(Boolean b) {
        return !Predef$.MODULE$.Boolean2boolean(b);
    }

    @Inject
    public UserProvisioning(UsersRepository usersRepository, MetricFactory metricFactory, JMAPConfiguration jmapConfiguration) {
        this.usersRepository = usersRepository;
        this.metricFactory = metricFactory;
        this.jmapConfiguration = jmapConfiguration;
    }
}

