/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanMeta;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlClassMeta;
import org.apache.juneau.xml.XmlCommon;
import org.apache.juneau.xml.XmlMetaProvider;
import org.apache.juneau.xml.XmlSerializerBuilder;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xmlschema.XmlSchemaSerializer;

@ConfigurableContext
public class XmlSerializer
extends WriterSerializer
implements XmlMetaProvider,
XmlCommon {
    static final String PREFIX = "XmlSerializer";
    public static final String XML_addBeanTypes = "XmlSerializer.addBeanTypes.b";
    public static final String XML_addNamespaceUrisToRoot = "XmlSerializer.addNamespaceUrisToRoot.b";
    public static final String XML_autoDetectNamespaces = "XmlSerializer.autoDetectNamespaces.b";
    public static final String XML_defaultNamespace = "XmlSerializer.defaultNamespace.s";
    public static final String XML_enableNamespaces = "XmlSerializer.enableNamespaces.b";
    public static final String XML_namespaces = "XmlSerializer.namespaces.ls";
    public static final String XML_xsNamespace = "XmlSerializer.xsNamespace.s";
    public static final XmlSerializer DEFAULT = new XmlSerializer(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_SQ = new Sq(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_SQ_READABLE = new SqReadable(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS = new Ns(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS_SQ = new NsSq(PropertyStore.DEFAULT);
    public static final XmlSerializer DEFAULT_NS_SQ_READABLE = new NsSqReadable(PropertyStore.DEFAULT);
    protected static final Namespace DEFAULT_JUNEAU_NAMESPACE = Namespace.create("juneau", "http://www.apache.org/2013/Juneau");
    protected static final Namespace DEFAULT_XS_NAMESPACE = Namespace.create("xs", "http://www.w3.org/2001/XMLSchema");
    private final boolean autoDetectNamespaces;
    private final boolean enableNamespaces;
    private final boolean addNamespaceUrlsToRoot;
    private final boolean addBeanTypes;
    private final Namespace defaultNamespace;
    private final Namespace xsNamespace;
    private final Namespace[] namespaces;
    private final Map<ClassMeta<?>, XmlClassMeta> xmlClassMetas = new ConcurrentHashMap();
    private final Map<BeanMeta<?>, XmlBeanMeta> xmlBeanMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, XmlBeanPropertyMeta> xmlBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, XmlBeanPropertyMeta>();
    private volatile XmlSchemaSerializer schemaSerializer;

    public XmlSerializer(PropertyStore ps) {
        this(ps, "text/xml", null);
    }

    public XmlSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.autoDetectNamespaces = this.getBooleanProperty(XML_autoDetectNamespaces, true);
        this.enableNamespaces = this.getBooleanProperty(XML_enableNamespaces, false);
        this.addNamespaceUrlsToRoot = this.getBooleanProperty(XML_addNamespaceUrisToRoot, false);
        this.defaultNamespace = this.getInstanceProperty(XML_defaultNamespace, Namespace.class, DEFAULT_JUNEAU_NAMESPACE);
        this.addBeanTypes = this.getBooleanProperty(XML_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
        this.xsNamespace = this.getInstanceProperty(XML_xsNamespace, Namespace.class, DEFAULT_XS_NAMESPACE);
        this.namespaces = this.getInstanceArrayProperty(XML_namespaces, Namespace.class, new Namespace[0]);
    }

    @Override
    public XmlSerializerBuilder builder() {
        return new XmlSerializerBuilder(this.getPropertyStore());
    }

    public static XmlSerializerBuilder create() {
        return new XmlSerializerBuilder();
    }

    public XmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = this.builder().build(XmlSchemaSerializer.class);
        }
        return this.schemaSerializer;
    }

    @Override
    public XmlSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public XmlSerializerSession createSession(SerializerSessionArgs args) {
        return new XmlSerializerSession(this, args);
    }

    @Override
    public XmlClassMeta getXmlClassMeta(ClassMeta<?> cm) {
        XmlClassMeta m = this.xmlClassMetas.get(cm);
        if (m == null) {
            m = new XmlClassMeta(cm, this);
            this.xmlClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public XmlBeanMeta getXmlBeanMeta(BeanMeta<?> bm) {
        XmlBeanMeta m = this.xmlBeanMetas.get(bm);
        if (m == null) {
            m = new XmlBeanMeta(bm, this);
            this.xmlBeanMetas.put(bm, m);
        }
        return m;
    }

    @Override
    public XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        XmlBeanPropertyMeta m = this.xmlBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new XmlBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.xmlBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isAddNamespaceUrlsToRoot() {
        return this.addNamespaceUrlsToRoot;
    }

    protected final boolean isAutoDetectNamespaces() {
        return this.autoDetectNamespaces;
    }

    protected final Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected final boolean isEnableNamespaces() {
        return this.enableNamespaces;
    }

    protected final Namespace[] getNamespaces() {
        return this.namespaces;
    }

    protected final Namespace getXsNamespace() {
        return this.xsNamespace;
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap().append("autoDetectNamespaces", this.autoDetectNamespaces).append("enableNamespaces", this.enableNamespaces).append("addNamespaceUrlsToRoot", this.addNamespaceUrlsToRoot).append("defaultNamespace", this.defaultNamespace).append("xsNamespace", this.xsNamespace).append("namespaces", this.namespaces).append("addBeanTypes", this.addBeanTypes));
    }

    public static class NsSqReadable
    extends XmlSerializer {
        public NsSqReadable(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class NsSq
    extends XmlSerializer {
        public NsSq(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }

    public static class Ns
    extends XmlSerializer {
        public Ns(PropertyStore ps) {
            super(ps.builder().set(XmlSerializer.XML_enableNamespaces, true).build(), "text/xml", "text/xml+simple");
        }
    }

    public static class SqReadable
    extends XmlSerializer {
        public SqReadable(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).set("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Sq
    extends XmlSerializer {
        public Sq(PropertyStore ps) {
            super(ps.builder().set("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }
}

