/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.collections;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.utils.PojoRest;

public class OList
extends ObjectList {
    private static final long serialVersionUID = 1L;
    transient BeanSession session = null;
    private transient PojoRest pojoRest;
    public static final OList EMPTY_LIST = new OList(){
        private static final long serialVersionUID = 1L;

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<Object> listIterator(int location) {
            return Collections.emptyList().listIterator(location);
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Object> subList(int start, int end) {
            return Collections.emptyList().subList(start, end);
        }
    };

    public OList() {
    }

    public OList(BeanSession session) {
        this.session = session;
    }

    public OList(Collection<?> copyFrom) {
        super(copyFrom);
    }

    public OList(CharSequence json) throws ParseException {
        this(json, (Parser)JsonParser.DEFAULT);
    }

    public OList(CharSequence in, Parser p) throws ParseException {
        this(p == null ? null : p.createBeanSession());
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        if (in != null) {
            p.parseIntoCollection(in, this, this.bs().object());
        }
    }

    public OList(Reader json) throws ParseException {
        this.parse(json, JsonParser.DEFAULT);
    }

    public OList(Reader in, Parser p) throws ParseException {
        this(p == null ? null : p.createBeanSession());
        this.parse(in, p);
    }

    public OList(Object ... entries) {
        Collections.addAll(this, entries);
    }

    public static OList of() {
        return new OList();
    }

    public static OList ofAll(Collection<?> in) {
        return in == null ? null : new OList(in);
    }

    public static OList ofJson(CharSequence json) throws ParseException {
        return json == null ? null : new OList(json);
    }

    public static OList ofText(CharSequence in, Parser p) throws ParseException {
        return in == null ? null : new OList(in, p);
    }

    public static OList ofJson(Reader json) throws ParseException {
        return json == null ? null : new OList(json);
    }

    public static OList ofText(Reader in, Parser p) throws ParseException {
        return in == null ? null : new OList(in);
    }

    public static OList of(Object ... entries) {
        return new OList(entries);
    }

    public OList session(BeanSession session) {
        this.session = session;
        return this;
    }

    public OList a(Object o) {
        this.add(o);
        return this;
    }

    public OList append(Object o) {
        this.add(o);
        return this;
    }

    public OList a(Object ... o) {
        for (Object o2 : o) {
            this.add(o2);
        }
        return this;
    }

    @Override
    public OList append(Object ... o) {
        for (Object o2 : o) {
            this.add(o2);
        }
        return this;
    }

    public OList aa(Collection<?> c) {
        if (c != null) {
            this.addAll(c);
        }
        return this;
    }

    public OList appendAll(Collection<?> c) {
        if (c != null) {
            this.addAll(c);
        }
        return this;
    }

    public OList aif(boolean b, Object val) {
        if (b) {
            this.a(val);
        }
        return this;
    }

    public OList appendIf(boolean b, Object val) {
        return this.aif(b, val);
    }

    public OList aifne(String ... o) {
        for (String s : o) {
            if (!StringUtils.isNotEmpty(s)) continue;
            this.add(s);
        }
        return this;
    }

    @Override
    public OList appendIfNotEmpty(String ... o) {
        return this.aifne(o);
    }

    public OList aifnn(Object ... o) {
        for (Object o2 : o) {
            if (o2 == null) continue;
            this.add(o2);
        }
        return this;
    }

    @Override
    public OList appendIfNotNull(Object ... o) {
        return this.aifnn(o);
    }

    public OList aif(Predicate<Object> p, Object val) {
        if (p.test(val)) {
            this.a(val);
        }
        return this;
    }

    public OList appendIf(Predicate<Object> p, Object val) {
        return this.aif(p, val);
    }

    @Override
    public <T> T get(int index, Class<T> type) {
        return this.bs().convertToType(this.get(index), type);
    }

    @Override
    public <T> T get(int index, Type type, Type ... args) {
        return this.bs().convertToType(this.get(index), type, args);
    }

    @Override
    public String getString(int index) {
        return this.get(index, String.class);
    }

    @Override
    public Integer getInt(int index) {
        return this.get(index, Integer.class);
    }

    @Override
    public Boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    @Override
    public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    public OMap getMap(int index) {
        return this.get(index, OMap.class);
    }

    public OList getList(int index) {
        return this.get(index, OList.class);
    }

    @Override
    public <T> T getAt(String path, Class<T> type) {
        return this.getPojoRest().get(path, type);
    }

    @Override
    public <T> T getAt(String path, Type type, Type ... args) {
        return this.getPojoRest().get(path, type, args);
    }

    @Override
    public Object putAt(String path, Object o) {
        return this.getPojoRest().put(path, o);
    }

    @Override
    public Object postAt(String path, Object o) {
        return this.getPojoRest().post(path, o);
    }

    @Override
    public Object deleteAt(String path) {
        return this.getPojoRest().delete(path);
    }

    @Override
    public BeanSession getBeanSession() {
        return this.session;
    }

    @Override
    public <E> Iterable<E> elements(final Class<E> childType) {
        final Iterator i = this.iterator();
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public E next() {
                        return OList.this.bs().convertToType(i.next(), childType);
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ClassMeta<?> getClassMeta(int index) {
        return this.bs().getClassMetaForObject(this.get(index));
    }

    public String asString(WriterSerializer serializer) {
        return serializer.toString(this);
    }

    public String asString() {
        return SimpleJsonSerializer.DEFAULT.toString(this);
    }

    @Override
    public boolean isUnmodifiable() {
        return false;
    }

    @Override
    public OList modifiable() {
        if (this.isUnmodifiable()) {
            return new OList((Collection<?>)this);
        }
        return this;
    }

    @Override
    public OList unmodifiable() {
        if (this instanceof UnmodifiableOList) {
            return this;
        }
        return new UnmodifiableOList(this);
    }

    public OList writeTo(Writer w) throws IOException, SerializeException {
        JsonSerializer.DEFAULT.serialize(this, w);
        return this;
    }

    @Override
    public Object cast(ClassMeta<?> cm) {
        try {
            return JsonParser.DEFAULT.parse(SimpleJsonSerializer.DEFAULT.serialize(this), cm);
        }
        catch (ParseException | SerializeException e) {
            throw new RuntimeException(e);
        }
    }

    private void parse(Reader r, Parser p) throws ParseException {
        if (p == null) {
            p = JsonParser.DEFAULT;
        }
        p.parseIntoCollection(r, this, this.bs().object());
    }

    private PojoRest getPojoRest() {
        if (this.pojoRest == null) {
            this.pojoRest = new PojoRest(this);
        }
        return this.pojoRest;
    }

    BeanSession bs() {
        if (this.session == null) {
            this.session = BeanContext.DEFAULT.createBeanSession();
        }
        return this.session;
    }

    @Override
    public String toString() {
        return SimpleJson.DEFAULT.toString(this);
    }

    private static final class UnmodifiableOList
    extends OList {
        private static final long serialVersionUID = 1L;

        UnmodifiableOList(OList contents) {
            if (contents != null) {
                for (Object e : this) {
                    super.add(e);
                }
            }
        }

        @Override
        public void add(int location, Object object) {
            throw new UnsupportedOperationException("OList is read-only.");
        }

        @Override
        public Object remove(int location) {
            throw new UnsupportedOperationException("OList is read-only.");
        }

        @Override
        public Object set(int location, Object object) {
            throw new UnsupportedOperationException("OList is read-only.");
        }

        @Override
        public final boolean isUnmodifiable() {
            return true;
        }
    }
}

