/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters(returns="FluentZonedDateTimeAssertion<R>")
public class FluentZonedDateTimeAssertion<R>
extends FluentComparableAssertion<R> {
    private final ZonedDateTime value;

    public FluentZonedDateTimeAssertion(ZonedDateTime value, R returns) {
        this(null, value, returns);
    }

    public FluentZonedDateTimeAssertion(Assertion creator, ZonedDateTime value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    public R isEqual(ZonedDateTime value, ChronoUnit precision) throws AssertionError {
        if (ObjectUtils.ne(this.value, value, (x, y) -> x.toInstant().truncatedTo(precision).equals(y.toInstant().truncatedTo(precision)))) {
            throw this.error("Unexpected value.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isAfter(ZonedDateTime value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (!this.value.isAfter(value)) {
            throw this.error("Value was not after expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isAfterNow() throws AssertionError {
        return this.isAfter(ZonedDateTime.now());
    }

    public R isBefore(ZonedDateTime value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (!this.value.isBefore(value)) {
            throw this.error("Value was not before expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isBeforeNow() throws AssertionError {
        return this.isBefore(ZonedDateTime.now());
    }

    public R isBetween(ZonedDateTime lower, ZonedDateTime upper) throws AssertionError {
        this.exists();
        this.assertNotNull("lower", lower);
        this.assertNotNull("upper", upper);
        this.isBefore(upper);
        this.isAfter(lower);
        return this.returns();
    }

    @Override
    public FluentZonedDateTimeAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentZonedDateTimeAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

