/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.HashMap;
import java.util.List;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.ResolvedFeatureCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="start", description="Start features with the specified name and version.")
@Service
public class StartFeaturesCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="feature", description="The name and version of the features to start. A feature id looks like name/version.", required=true, multiValued=true)
    @Completion(value=ResolvedFeatureCompleter.class)
    List<String> features;
    @Option(name="-v", aliases={"--verbose"}, description="Explain what is being done", required=false, multiValued=false)
    boolean verbose;
    @Option(name="-t", aliases={"--simulate"}, description="Perform a simulation only", required=false, multiValued=false)
    boolean simulate;
    @Option(name="-g", aliases={"--region"}, description="Region to apply to")
    String region = "root";

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        this.addOption(FeaturesService.Option.Simulate, this.simulate);
        this.addOption(FeaturesService.Option.Verbose, this.verbose);
        HashMap stateChanges = new HashMap();
        HashMap<String, FeatureState> regionChanges = new HashMap<String, FeatureState>();
        for (String featureId : this.getFeatureIds(admin, this.features)) {
            regionChanges.put(featureId, FeatureState.Started);
        }
        stateChanges.put(this.region, regionChanges);
        admin.updateFeaturesState(stateChanges, this.options);
    }
}

