/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.opensaml.ExpiredAssertionException;
import org.opensaml.FatalProfileException;
import org.opensaml.InvalidAssertionException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAudienceRestrictionCondition;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;

public class SAMLPOSTProfile {
    private static Logger log = Logger.getLogger((String)SAMLPOSTProfile.class.getName());
    private static TreeMap replayExpMap = new TreeMap();
    private static HashSet replayCache = new HashSet();

    public static SAMLAssertion getSSOAssertion(SAMLResponse sAMLResponse, Collection collection) throws SAMLException {
        int n = 0;
        boolean bl = false;
        Iterator iterator = sAMLResponse.getAssertions();
        block0: while (iterator.hasNext()) {
            Object object;
            ++n;
            bl = false;
            SAMLAssertion sAMLAssertion = (SAMLAssertion)iterator.next();
            Date date = sAMLAssertion.getNotBefore();
            Date date2 = sAMLAssertion.getNotOnOrAfter();
            if (date == null || date2 == null) continue;
            if (date.getTime() - 300000L > System.currentTimeMillis()) {
                bl = true;
                continue;
            }
            if (date2.getTime() + 300000L <= System.currentTimeMillis()) {
                bl = true;
                continue;
            }
            Iterator iterator2 = sAMLAssertion.getConditions();
            while (iterator2.hasNext()) {
                object = (SAMLCondition)iterator2.next();
                if (object instanceof SAMLAudienceRestrictionCondition && ((SAMLAudienceRestrictionCondition)object).eval(collection)) continue;
                continue block0;
            }
            object = sAMLAssertion.getStatements();
            while (object.hasNext()) {
                SAMLStatement sAMLStatement = (SAMLStatement)object.next();
                if (!(sAMLStatement instanceof SAMLAuthenticationStatement)) continue;
                SAMLSubject sAMLSubject = ((SAMLAuthenticationStatement)sAMLStatement).getSubject();
                Iterator iterator3 = sAMLSubject.getConfirmationMethods();
                while (iterator3.hasNext()) {
                    if (!((String)iterator3.next()).equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
                    return sAMLAssertion;
                }
            }
        }
        if (bl && n == 1) {
            throw new ExpiredAssertionException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOAssertion() unable to find a SSO assertion with valid time condition");
        }
        throw new FatalProfileException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOAssertion() unable to find a valid SSO assertion");
    }

    public static SAMLAuthenticationStatement getSSOStatement(SAMLAssertion sAMLAssertion) throws SAMLException {
        Iterator iterator = sAMLAssertion.getStatements();
        while (iterator.hasNext()) {
            SAMLStatement sAMLStatement = (SAMLStatement)iterator.next();
            if (!(sAMLStatement instanceof SAMLAuthenticationStatement)) continue;
            SAMLSubject sAMLSubject = ((SAMLAuthenticationStatement)sAMLStatement).getSubject();
            Iterator iterator2 = sAMLSubject.getConfirmationMethods();
            while (iterator2.hasNext()) {
                if (!((String)iterator2.next()).equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) continue;
                return (SAMLAuthenticationStatement)sAMLStatement;
            }
        }
        throw new FatalProfileException(SAMLException.RESPONDER, "SAMLPOSTProfile.getSSOStatement() unable to find a valid SSO statement");
    }

    public static synchronized boolean checkReplayCache(SAMLAssertion sAMLAssertion) {
        Set<Date> set = replayExpMap.headMap(new Date()).keySet();
        Object object = set.iterator();
        while (object.hasNext()) {
            replayCache.remove(replayExpMap.get(object.next()));
        }
        set.clear();
        if (!replayCache.add(sAMLAssertion.getId())) {
            return false;
        }
        object = new Date(sAMLAssertion.getNotOnOrAfter().getTime() + 300000L);
        while (replayExpMap.containsKey(object)) {
            ((Date)object).setTime(((Date)object).getTime() + 1L);
        }
        replayExpMap.put(object, sAMLAssertion.getId());
        return true;
    }

    public static SAMLResponse accept(byte[] byArray, String string, int n, boolean bl) throws SAMLException {
        try {
            SAMLResponse sAMLResponse = new SAMLResponse(new ByteArrayInputStream(Base64.decode((byte[])byArray)));
            if (bl) {
                SAMLPOSTProfile.process(sAMLResponse, string, n);
            }
            return sAMLResponse;
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new InvalidAssertionException(SAMLException.REQUESTER, "SAMLPOSTProfile.accept() unable to decode base64 response");
        }
    }

    public static void process(SAMLResponse sAMLResponse, String string, int n) throws SAMLException {
        if (string == null || string.length() == 0 || !string.equals(sAMLResponse.getRecipient())) {
            throw new InvalidAssertionException(SAMLException.REQUESTER, "SAMLPOSTProfile.accept() detected recipient mismatch: " + sAMLResponse.getRecipient());
        }
        if (sAMLResponse.getIssueInstant().getTime() + (long)(1000 * n) + 300000L < System.currentTimeMillis()) {
            throw new ExpiredAssertionException(SAMLException.RESPONDER, "SAMLPOSTProfile.accept() detected expired response");
        }
    }

    public static SAMLResponse prepare(String string, String string2, Collection collection, String string3, String string4, String string5, String string6, String string7, Date date, Collection collection2) throws SAMLException {
        return SAMLPOSTProfile.prepare(string, string2, collection, new SAMLNameIdentifier(string3, string4, string5), string6, string7, date, collection2);
    }

    public static SAMLResponse prepare(String string, String string2, Collection collection, SAMLNameIdentifier sAMLNameIdentifier, String string3, String string4, Date date, Collection collection2) throws SAMLException {
        log.info((Object)"Creating SAML Response.");
        if (string == null || string.length() == 0) {
            throw new SAMLException(SAMLException.RESPONDER, "SAMLPOSTProfile.prepare() requires recipient");
        }
        Vector<SAMLAudienceRestrictionCondition> vector = new Vector<SAMLAudienceRestrictionCondition>(1);
        if (collection != null && collection.size() > 0) {
            vector.add(new SAMLAudienceRestrictionCondition(collection));
        }
        String[] stringArray = new String[]{"urn:oasis:names:tc:SAML:1.0:cm:bearer"};
        SAMLSubject sAMLSubject = new SAMLSubject(sAMLNameIdentifier, Arrays.asList(stringArray), null, null);
        SAMLStatement[] sAMLStatementArray = new SAMLStatement[]{new SAMLAuthenticationStatement(sAMLSubject, string4, date, string3, null, collection2)};
        SAMLAssertion[] sAMLAssertionArray = new SAMLAssertion[]{new SAMLAssertion(string2, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 300000L), vector, null, Arrays.asList(sAMLStatementArray))};
        return new SAMLResponse(null, string, Arrays.asList(sAMLAssertionArray), null);
    }
}

