/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnection;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectionManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.AuthorityConnectorManagerFactory;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnection;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectionManager;
import org.apache.manifoldcf.authorities.interfaces.IAuthorityConnectorManager;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.tests.BasePostgresql;
import org.junit.After;
import org.junit.Before;

public class ConnectorBasePostgresql
extends BasePostgresql {
    protected String[] getConnectorClasses() {
        return new String[0];
    }

    protected String[] getConnectorNames() {
        return new String[0];
    }

    protected String[] getAuthorityClasses() {
        return new String[0];
    }

    protected String[] getAuthorityNames() {
        return new String[0];
    }

    protected String[] getOutputClasses() {
        return new String[0];
    }

    protected String[] getOutputNames() {
        return new String[0];
    }

    protected void writeConnectors(StringBuilder output) throws Exception {
        String[] connectorClasses = this.getConnectorClasses();
        String[] connectorNames = this.getConnectorNames();
        for (int i = 0; i < connectorNames.length; ++i) {
            output.append("    <repositoryconnector name=\"" + connectorNames[i] + "\" class=\"" + connectorClasses[i] + "\"/>\n");
        }
        String[] outputClasses = this.getOutputClasses();
        String[] outputNames = this.getOutputNames();
        for (int i = 0; i < outputNames.length; ++i) {
            output.append("    <outputconnector name=\"" + outputNames[i] + "\" class=\"" + outputClasses[i] + "\"/>\n");
        }
        String[] authorityClasses = this.getAuthorityClasses();
        String[] authorityNames = this.getAuthorityNames();
        for (int i = 0; i < authorityNames.length; ++i) {
            output.append("    <authorityconnector name=\"" + authorityNames[i] + "\" class=\"" + authorityClasses[i] + "\"/>\n");
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.initializeSystem();
        try {
            this.localReset();
        }
        catch (Exception e) {
            System.out.println("Warning: Preclean failed: " + e.getMessage());
        }
        try {
            this.localSetUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    protected void localSetUp() throws Exception {
        super.localSetUp();
        IThreadContext tc = ThreadContextFactory.make();
        IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
        IConnectorManager mgr = ConnectorManagerFactory.make((IThreadContext)tc);
        IAuthorityConnectorManager authMgr = AuthorityConnectorManagerFactory.make((IThreadContext)tc);
        IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
        IOutputConnectorManager outputMgr = OutputConnectorManagerFactory.make((IThreadContext)tc);
        IOutputConnectionManager outputConnManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
        database.beginTransaction();
        try {
            int i;
            String[] connectorClasses = this.getConnectorClasses();
            String[] connectorNames = this.getConnectorNames();
            for (i = 0; i < connectorClasses.length; ++i) {
                mgr.registerConnector(connectorNames[i], connectorClasses[i]);
                String[] connectionNames = connManager.findConnectionsForConnector(connectorClasses[i]);
                jobManager.noteConnectorRegistration(connectionNames);
            }
            String[] authorityClasses = this.getAuthorityClasses();
            String[] authorityNames = this.getAuthorityNames();
            for (i = 0; i < authorityClasses.length; ++i) {
                authMgr.registerConnector(authorityNames[i], authorityClasses[i]);
            }
            String[] outputClasses = this.getOutputClasses();
            String[] outputNames = this.getOutputNames();
            for (i = 0; i < outputClasses.length; ++i) {
                outputMgr.registerConnector(outputNames[i], outputClasses[i]);
                String[] connectionNames = outputConnManager.findConnectionsForConnector(outputClasses[i]);
                AgentManagerFactory.noteOutputConnectorRegistration((IThreadContext)tc, (String[])connectionNames);
            }
        }
        catch (ManifoldCFException e) {
            database.signalRollback();
            throw e;
        }
        catch (Error e) {
            database.signalRollback();
            throw e;
        }
        finally {
            database.endTransaction();
        }
    }

    @Override
    @After
    public void cleanUp() throws Exception {
        try {
            this.localCleanUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        this.cleanupSystem();
    }

    @Override
    protected void localCleanUp() throws Exception {
        Exception currentException;
        block20: {
            block19: {
                IThreadContext tc = ThreadContextFactory.make();
                currentException = null;
                try {
                    IRepositoryConnectionManager connMgr = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
                    IAuthorityConnectionManager authConnMgr = AuthorityConnectionManagerFactory.make((IThreadContext)tc);
                    IOutputConnectionManager outputMgr = OutputConnectionManagerFactory.make((IThreadContext)tc);
                    IRepositoryConnection[] connections = connMgr.getAllConnections();
                    int i = 0;
                    while (i < connections.length) {
                        connMgr.delete(connections[i++].getName());
                    }
                    IAuthorityConnection[] authorities = authConnMgr.getAllConnections();
                    i = 0;
                    while (i < authorities.length) {
                        authConnMgr.delete(authorities[i++].getName());
                    }
                    IOutputConnection[] outputs = outputMgr.getAllConnections();
                    i = 0;
                    while (i < outputs.length) {
                        outputMgr.delete(outputs[i++].getName());
                    }
                }
                catch (Exception e) {
                    currentException = e;
                }
                try {
                    IDBInterface database = DBInterfaceFactory.make((IThreadContext)tc, (String)ManifoldCF.getMasterDatabaseName(), (String)ManifoldCF.getMasterDatabaseUsername(), (String)ManifoldCF.getMasterDatabasePassword());
                    IConnectorManager mgr = ConnectorManagerFactory.make((IThreadContext)tc);
                    IAuthorityConnectorManager authMgr = AuthorityConnectorManagerFactory.make((IThreadContext)tc);
                    IOutputConnectorManager outputMgr = OutputConnectorManagerFactory.make((IThreadContext)tc);
                    IOutputConnectionManager outputConnManager = OutputConnectionManagerFactory.make((IThreadContext)tc);
                    IJobManager jobManager = JobManagerFactory.make((IThreadContext)tc);
                    IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make((IThreadContext)tc);
                    database.beginTransaction();
                    try {
                        int i;
                        String[] connectorClasses = this.getConnectorClasses();
                        for (i = 0; i < connectorClasses.length; ++i) {
                            String[] connectionNames = connManager.findConnectionsForConnector(connectorClasses[i]);
                            jobManager.noteConnectorDeregistration(connectionNames);
                            mgr.unregisterConnector(connectorClasses[i]);
                        }
                        String[] authorityClasses = this.getAuthorityClasses();
                        for (i = 0; i < authorityClasses.length; ++i) {
                            authMgr.unregisterConnector(authorityClasses[i]);
                        }
                        String[] outputClasses = this.getOutputClasses();
                        for (i = 0; i < outputClasses.length; ++i) {
                            String[] connectionNames = outputConnManager.findConnectionsForConnector(outputClasses[i]);
                            AgentManagerFactory.noteOutputConnectorDeregistration((IThreadContext)tc, (String[])connectionNames);
                            outputMgr.unregisterConnector(outputClasses[i]);
                        }
                    }
                    catch (ManifoldCFException e) {
                        database.signalRollback();
                        throw e;
                    }
                    catch (Error e) {
                        database.signalRollback();
                        throw e;
                    }
                    finally {
                        database.endTransaction();
                    }
                }
                catch (Exception e) {
                    if (currentException == null) break block19;
                    currentException = e;
                }
            }
            try {
                super.localCleanUp();
            }
            catch (Exception e) {
                if (currentException == null) break block20;
                currentException = e;
            }
        }
        if (currentException != null) {
            throw currentException;
        }
    }
}

