/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services.xml;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.function.Function;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;

@Experimental
public interface XmlWriterRequest<T> {
    @Nullable
    public Path getPath();

    @Nullable
    public OutputStream getOutputStream();

    @Nullable
    public Writer getWriter();

    @Nonnull
    public T getContent();

    @Nullable
    public Function<Object, String> getInputLocationFormatter();

    public static <T> XmlWriterRequestBuilder<T> builder() {
        return new XmlWriterRequestBuilder();
    }

    public static class XmlWriterRequestBuilder<T> {
        Path path;
        OutputStream outputStream;
        Writer writer;
        T content;
        Function<Object, String> inputLocationFormatter;

        public XmlWriterRequestBuilder<T> path(Path path) {
            this.path = path;
            return this;
        }

        public XmlWriterRequestBuilder<T> outputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public XmlWriterRequestBuilder<T> writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public XmlWriterRequestBuilder<T> content(T content) {
            this.content = content;
            return this;
        }

        public XmlWriterRequestBuilder<T> inputLocationFormatter(Function<Object, String> inputLocationFormatter) {
            this.inputLocationFormatter = inputLocationFormatter;
            return this;
        }

        public XmlWriterRequest<T> build() {
            return new DefaultXmlWriterRequest<T>(this.path, this.outputStream, this.writer, this.content, this.inputLocationFormatter);
        }

        private static class DefaultXmlWriterRequest<T>
        implements XmlWriterRequest<T> {
            final Path path;
            final OutputStream outputStream;
            final Writer writer;
            final T content;
            final Function<Object, String> inputLocationFormatter;

            DefaultXmlWriterRequest(Path path, OutputStream outputStream, Writer writer, T content, Function<Object, String> inputLocationFormatter) {
                this.path = path;
                this.outputStream = outputStream;
                this.writer = writer;
                this.content = content;
                this.inputLocationFormatter = inputLocationFormatter;
            }

            @Override
            public Path getPath() {
                return this.path;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.outputStream;
            }

            @Override
            public Writer getWriter() {
                return this.writer;
            }

            @Override
            public T getContent() {
                return this.content;
            }

            @Override
            public Function<Object, String> getInputLocationFormatter() {
                return this.inputLocationFormatter;
            }
        }
    }
}

