/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.client;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jline.terminal.impl.Diag;
import org.jline.terminal.spi.SystemStream;
import org.jline.terminal.spi.TerminalExt;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.mvndaemon.mvnd.client.BuildProperties;
import org.mvndaemon.mvnd.client.Client;
import org.mvndaemon.mvnd.client.Completion;
import org.mvndaemon.mvnd.client.DaemonClientConnection;
import org.mvndaemon.mvnd.client.DaemonConnector;
import org.mvndaemon.mvnd.client.DaemonParameters;
import org.mvndaemon.mvnd.client.ExecutionResult;
import org.mvndaemon.mvnd.common.DaemonException;
import org.mvndaemon.mvnd.common.DaemonInfo;
import org.mvndaemon.mvnd.common.DaemonRegistry;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.Message;
import org.mvndaemon.mvnd.common.OsUtils;
import org.mvndaemon.mvnd.common.TimeUtils;
import org.mvndaemon.mvnd.common.logging.ClientOutput;
import org.mvndaemon.mvnd.common.logging.TerminalOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.slf4j.impl.MvndLoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    private final DaemonParameters parameters;

    public static void main(String[] argv) throws Exception {
        Path dir;
        DaemonParameters parameters;
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argv));
        Path logFile = null;
        String sLogFile = Environment.MAVEN_LOG_FILE.removeCommandLineOption(args);
        if (sLogFile != null) {
            if (sLogFile.isEmpty()) {
                throw new IllegalArgumentException("-l and --log-file need to be followed by a path");
            }
            logFile = Paths.get(sLogFile, new String[0]);
        }
        if (Environment.DIAG.removeCommandLineOption(args) != null) {
            Diag.diag((PrintStream)System.out);
            return;
        }
        if (Environment.SERIAL.removeCommandLineOption(args) != null) {
            System.setProperty(Environment.SERIAL.getProperty(), Boolean.toString(true));
        }
        boolean batchMode = Environment.MAVEN_BATCH_MODE.hasCommandLineOption(args) || Environment.COMPLETION.hasCommandLineOption(args);
        String userJdkJavaOpts = System.getenv(Environment.JDK_JAVA_OPTIONS.getEnvironmentVariable());
        if (userJdkJavaOpts != null) {
            Environment.JDK_JAVA_OPTIONS.addCommandLineOption(args, userJdkJavaOpts);
        }
        DefaultClient.setSystemPropertiesFromCommandLine(args);
        if (LoggerFactory.getILoggerFactory() instanceof MvndLoggerFactory) {
            ((MvndLoggerFactory)LoggerFactory.getILoggerFactory()).reconfigure();
        }
        if ((parameters = new DaemonParameters()).serial()) {
            System.setProperty(Environment.MVND_THREADS.getProperty(), Integer.toString(1));
            System.setProperty(Environment.MVND_BUILDER.getProperty(), "singlethreaded");
            System.setProperty(Environment.MVND_NO_BUFERING.getProperty(), Boolean.toString(true));
        }
        System.setProperty(Environment.MVND_HOME.getProperty(), parameters.mvndHome().toString());
        if (Environment.MAVEN_FILE.hasCommandLineOption(args)) {
            dir = parameters.userDir().resolve(Environment.MAVEN_FILE.getCommandLineOption(args));
            if (Files.isRegularFile(dir, new LinkOption[0])) {
                dir = dir.getParent();
            }
            dir = dir.normalize();
        } else {
            dir = parameters.userDir();
        }
        Path multiModuleProjectDirectory = parameters.multiModuleProjectDirectory(dir);
        System.setProperty(Environment.MAVEN_MULTIMODULE_PROJECT_DIRECTORY.getProperty(), multiModuleProjectDirectory.toString());
        Environment.MAVEN_MULTIMODULE_PROJECT_DIRECTORY.addCommandLineOption(args, multiModuleProjectDirectory.toString());
        if (Files.isRegularFile(parameters.jvmConfigPath(), new LinkOption[0])) {
            try (Stream<String> jvmArgs = Files.lines(parameters.jvmConfigPath());){
                String jvmArgsStr = jvmArgs.collect(Collectors.joining(" "));
                parameters = parameters.withJvmArgs(jvmArgsStr, false);
            }
        }
        SLF4JBridgeHandler.install();
        int exitCode = 0;
        boolean noBuffering = batchMode || parameters.noBuffering();
        try (TerminalOutput output = new TerminalOutput(noBuffering, parameters.rollingWindowSize(), logFile);){
            try {
                Environment.Color styleColor = Environment.Color.of((String)Environment.MAVEN_COLOR.removeCommandLineOption(args)).orElse(Environment.Color.auto);
                if (styleColor == Environment.Color.auto) {
                    boolean stdoutIsTerminal = ((TerminalExt)output.getTerminal()).getProvider().isSystemStream(SystemStream.Output);
                    styleColor = batchMode || logFile != null || !stdoutIsTerminal ? Environment.Color.never : Environment.Color.always;
                }
                args.add("-D" + Environment.MAVEN_COLOR.getProperty() + "=" + styleColor.name());
                ExecutionResult result = new DefaultClient(parameters).execute((ClientOutput)output, args);
                exitCode = result.getExitCode();
            }
            catch (DaemonException.InterruptedException e) {
                AttributedStyle s = new AttributedStyle().bold().foreground(1);
                String str = new AttributedString((CharSequence)(System.lineSeparator() + "Canceled by user"), s).toAnsi();
                output.accept((Message)Message.err((String)str));
                exitCode = 130;
            }
        }
        System.exit(exitCode);
    }

    public static void setSystemPropertiesFromCommandLine(List<String> args) {
        Iterator<String> iterator = args.iterator();
        boolean defineIsEmpty = false;
        while (iterator.hasNext()) {
            String arg = iterator.next();
            String val = Environment.MAVEN_DEFINE.removeCommandLineOption(new ArrayList<String>(Collections.singletonList(arg)));
            if (val == null && defineIsEmpty) {
                defineIsEmpty = false;
                String string = val = DefaultClient.maybeDefineCommandLineOption(arg) ? arg : "";
            }
            if (val == null) continue;
            if (val.isEmpty() && iterator.hasNext()) {
                defineIsEmpty = true;
                continue;
            }
            if (val.isEmpty()) {
                throw new IllegalArgumentException("Missing argument for option " + arg);
            }
            int eqPos = val.indexOf(61);
            if (eqPos >= 0) {
                String k = val.substring(0, eqPos);
                String v = val.substring(eqPos + 1);
                System.setProperty(k, v);
                LOGGER.trace("Setting system property {} to {}", (Object)k, (Object)v);
                continue;
            }
            System.setProperty(val, "");
            LOGGER.trace("Setting system property {}", (Object)val);
        }
    }

    private static boolean maybeDefineCommandLineOption(String arg) {
        return EnumSet.allOf(Environment.class).stream().filter(e -> e != Environment.MAVEN_DEFINE).noneMatch(e -> e.hasCommandLineOption(Collections.singletonList(arg)));
    }

    public DefaultClient(DaemonParameters parameters) {
        this.parameters = parameters.withJdkJavaOpts("--add-opens java.base/java.io=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/sun.net.www.protocol.jar=ALL-UNNAMED --add-opens java.base/sun.nio.fs=ALL-UNNAMED", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResult execute(ClientOutput output, List<String> argv) {
        DefaultClient.LOGGER.debug("Starting client");
        args = new ArrayList<String>(argv);
        completionShell = Environment.COMPLETION.removeCommandLineOption(args);
        if (completionShell != null) {
            output.accept((Message)Message.out((String)Completion.getCompletion(completionShell, this.parameters)));
            return DefaultResult.success(argv);
        }
        version = Environment.MAVEN_VERSION.hasCommandLineOption(args);
        showVersion = Environment.MAVEN_SHOW_VERSION.hasCommandLineOption(args);
        debug = Environment.MAVEN_DEBUG.hasCommandLineOption(args);
        if (version || showVersion || debug) {
            buildProperties = BuildProperties.getInstance();
            mvndVersionString = "Apache Maven Daemon (mvnd) " + buildProperties.getVersion() + " " + (String)(Environment.isNative() != false ? buildProperties.getOsName() + "-" + buildProperties.getOsArch() + " native client" : "JVM client") + " (" + buildProperties.getRevision() + ")";
            isColored = "never".equals(Environment.MAVEN_COLOR.getCommandLineOption(args)) == false;
            v = isColored != false ? new AttributedStringBuilder().style(AttributedStyle.BOLD).append((CharSequence)mvndVersionString).toAnsi() : mvndVersionString;
            output.accept((Message)Message.log((String)v));
            output.describeTerminal();
        }
        registry = new DaemonRegistry(this.parameters.registry());
        try {
            block48: {
                block47: {
                    if (Environment.STATUS.removeCommandLineOption(args) == null) break block47;
                    template = "%8s  %7s  %24s  %7s  %5s  %23s  %s";
                    output.accept((Message)Message.out((String)String.format("%8s  %7s  %24s  %7s  %5s  %23s  %s", new Object[]{"ID", "PID", "Address", "Status", "RSS", "Last activity", "Java home"})));
                    isColored = registry.getAll().iterator();
                    ** GOTO lbl61
                }
                if (Environment.STOP.removeCommandLineOption(args) == null) break block48;
                dis = registry.getAll().toArray(new DaemonInfo[0]);
                if (dis.length <= 0) ** GOTO lbl82
                output.accept((Message)Message.out((String)("Stopping " + dis.length + " running daemons")));
                isColored = dis;
                d = isColored.length;
                ** GOTO lbl71
            }
            if (Environment.PURGE.removeCommandLineOption(args) != null) {
                result = this.purgeLogs();
                output.accept((Message)Message.out((String)(result != null ? result : "Nothing to purge")));
                isColored = DefaultResult.success(argv);
                return isColored;
            }
            if (Environment.MVND_RAW_STREAMS.removeCommandLineOption(args) != null) {
                args.add("-D" + Environment.MVND_RAW_STREAMS.getProperty());
            }
            threads = Optional.ofNullable(Environment.MVND_THREADS.removeCommandLineOption(args));
            Environment.MVND_THREADS.addCommandLineOption(args, threads.orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, threads(), ()Ljava/lang/String;)((DaemonParameters)this.parameters)));
            builder = Optional.ofNullable(Environment.MVND_BUILDER.removeCommandLineOption(args));
            Environment.MVND_BUILDER.addCommandLineOption(args, builder.orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, builder(), ()Ljava/lang/String;)((DaemonParameters)this.parameters)));
            settings = Optional.ofNullable(Environment.MAVEN_SETTINGS.removeCommandLineOption(args)).or((Supplier<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute$2(), ()Ljava/util/Optional;)((DefaultClient)this));
            settings.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$3(java.util.List java.lang.String ), (Ljava/lang/String;)V)(args));
            repo = Optional.ofNullable(Environment.MAVEN_REPO_LOCAL.removeCommandLineOption(args)).or((Supplier<Optional>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute$4(), ()Ljava/util/Optional;)((DefaultClient)this));
            repo.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$5(java.util.List java.lang.String ), (Ljava/lang/String;)V)(args));
            width = Optional.ofNullable(Environment.MVND_TERMINAL_WIDTH.removeCommandLineOption(args)).orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$execute$6(org.mvndaemon.mvnd.common.logging.ClientOutput ), ()Ljava/lang/String;)((ClientOutput)output));
            Environment.MVND_TERMINAL_WIDTH.addCommandLineOption(args, width);
            connector = new DaemonConnector(this.parameters, registry);
            daemon = connector.connect(output);
            try {
                block49: {
                    break block49;
lbl61:
                    // 1 sources

                    while (true) {
                        if (!isColored.hasNext()) {
                            isColored = DefaultResult.success(argv);
                            return isColored;
                        }
                        d = (DaemonInfo)isColored.next();
                        if (ProcessHandle.of(d.getPid()).isEmpty()) {
                            registry.remove(d.getId());
                            continue;
                        }
                        output.accept((Message)Message.out((String)String.format("%8s  %7s  %24s  %7s  %5s  %23s  %s", new Object[]{d.getId(), d.getPid(), d.getAddress(), d.getState(), OsUtils.kbToHumanReadable((long)OsUtils.findProcessRssInKb((long)d.getPid())), LocalDateTime.ofInstant(Instant.ofEpochMilli(Math.max(d.getLastIdle(), d.getLastBusy())), ZoneId.systemDefault()), d.getJavaHome()})));
                    }
lbl71:
                    // 3 sources

                    for (var12_20 = 0; var12_20 < d; ++var12_20) {
                        di = isColored[var12_20];
                        try {
                            ProcessHandle.of(di.getPid()).ifPresent((Consumer<ProcessHandle>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, destroyForcibly(), (Ljava/lang/ProcessHandle;)V)());
                            continue;
                        }
                        catch (Exception t) {
                            System.out.println("Daemon " + di.getId() + ": " + String.valueOf(t));
                            continue;
                        }
                        finally {
                            registry.remove(di.getId());
                        }
                    }
lbl82:
                    // 2 sources

                    isColored = DefaultResult.success(argv);
                    return isColored;
                }
                output.setDaemonId(daemon.getDaemon().getId());
                output.setDaemonDispatch((Consumer<Message>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, dispatch(org.mvndaemon.mvnd.common.Message ), (Lorg/mvndaemon/mvnd/common/Message;)V)((DaemonClientConnection)daemon));
                output.setDaemonReceive((Consumer<Message>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, enqueue(org.mvndaemon.mvnd.common.Message ), (Lorg/mvndaemon/mvnd/common/Message;)V)((DaemonClientConnection)daemon));
                daemon.dispatch((Message)new Message.BuildRequest(args, this.parameters.userDir().toString(), this.parameters.multiModuleProjectDirectory().toString(), System.getenv()));
                output.accept((Message)Message.buildStatus((String)("Connected to daemon " + daemon.getDaemon().getId() + ", scanning for projects...")));
                purgeMessage = new AtomicReference<V>();
                purgeLog = new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$execute$7(java.util.concurrent.atomic.AtomicReference ), ()V)((DefaultClient)this, purgeMessage), "Log purge");
                purgeLog.setDaemon(true);
                purgeLog.start();
                try {
                    block37: while (true) {
                        messages = daemon.receive();
                        output.accept(messages);
                        var19_33 = messages.iterator();
                        while (true) {
                            if (!var19_33.hasNext()) continue block37;
                            m = var19_33.next();
                            switch (m.getType()) {
                                case 17: {
                                    var21_35 = new DefaultResult(argv, new InterruptedException("The build was canceled"), 130);
                                    return var21_35;
                                }
                                case 9: {
                                    e = (Message.BuildException)m;
                                    var22_38 = new DefaultResult(argv, new Exception(e.getClassName() + ": " + e.getMessage() + "\n" + e.getStackTrace()), 1);
                                    return var22_38;
                                }
                                case 3: {
                                    var22_39 = new DefaultResult(argv, null, ((Message.BuildFinished)m).getExitCode());
                                    return var22_39;
                                }
                            }
                        }
                        break;
                    }
                }
                finally {
                    msg = (String)purgeMessage.get();
                    if (msg != null) {
                        output.accept((Message)Message.err((String)msg));
                    }
                }
            }
            finally {
                if (daemon != null) {
                    daemon.close();
                }
            }
        }
        finally {
            registry.close();
        }
    }

    private String purgeLogs() {
        String logMessage;
        Path storage = this.parameters.daemonStorage();
        Duration purgeLogPeriod = this.parameters.purgeLogPeriod();
        if (!Files.isDirectory(storage, new LinkOption[0]) || !TimeUtils.isPositive((Duration)purgeLogPeriod)) {
            return null;
        }
        String date = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault()).format(Instant.now());
        Path log = storage.resolve("purge-" + date + ".log");
        ArrayList deleted = new ArrayList();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        FileTime limit = FileTime.from(Instant.now().minus(purgeLogPeriod));
        try (Stream<Path> storagePath = Files.list(storage);){
            storagePath.filter(p -> p.getFileName().toString().endsWith(".log")).filter(p -> !log.equals(p)).filter(p -> {
                try {
                    FileTime lmt = Files.getLastModifiedTime(p, new LinkOption[0]);
                    return lmt.compareTo(limit) < 0;
                }
                catch (IOException e) {
                    exceptions.add(e);
                    return false;
                }
            }).forEach(p -> {
                try {
                    Files.delete(p);
                    deleted.add(p);
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            });
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (exceptions.isEmpty() && deleted.isEmpty()) {
            return null;
        }
        try (PrintWriter w = new PrintWriter(Files.newBufferedWriter(log, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE));){
            w.printf("Purge executed at %s%n", Instant.now().toString());
            if (deleted.isEmpty()) {
                w.printf("No files deleted.%n", new Object[0]);
            } else {
                w.printf("Deleted files:%n", new Object[0]);
                for (Path path : deleted) {
                    w.printf("    %s%n", path.toString());
                }
            }
            if (!exceptions.isEmpty()) {
                w.printf("%d exception(s) occurred during the purge", exceptions.size());
                for (Throwable throwable : exceptions) {
                    throwable.printStackTrace(w);
                }
            }
            char[] buf = new char[80];
            Arrays.fill(buf, '=');
            w.printf("%s%n", new String(buf));
            logMessage = "log available in " + log.toString();
        }
        catch (IOException e) {
            logMessage = "an exception occurred when writing log to " + log.toString() + ": " + e.toString();
        }
        if (exceptions.isEmpty()) {
            return String.format("Purged %d log files (%s)", deleted.size(), logMessage);
        }
        return String.format("Purged %d log files with %d exceptions (%s)", deleted.size(), exceptions.size(), logMessage);
    }

    private /* synthetic */ void lambda$execute$7(AtomicReference purgeMessage) {
        purgeMessage.set(this.purgeLogs());
    }

    private static /* synthetic */ String lambda$execute$6(ClientOutput output) {
        int w = output.getTerminalWidth();
        return Integer.toString(w > 0 ? Math.max(w, 80) : 120);
    }

    private static /* synthetic */ void lambda$execute$5(List args, String r) {
        Environment.MAVEN_REPO_LOCAL.addCommandLineOption((Collection)args, r);
    }

    private /* synthetic */ Optional lambda$execute$4() {
        return Optional.ofNullable(this.parameters.mavenRepoLocal()).map(Path::toString);
    }

    private static /* synthetic */ void lambda$execute$3(List args, String s) {
        Environment.MAVEN_SETTINGS.addCommandLineOption((Collection)args, s);
    }

    private /* synthetic */ Optional lambda$execute$2() {
        return Optional.ofNullable(this.parameters.settings()).map(Path::toString);
    }

    private static class DefaultResult
    implements ExecutionResult {
        private final Exception exception;
        private final List<String> args;
        private final int exitCode;

        public static DefaultResult success(List<String> args) {
            return new DefaultResult(args, null, 0);
        }

        private DefaultResult(List<String> args, Exception exception, int exitCode) {
            this.args = args;
            this.exception = exception;
            this.exitCode = exitCode;
        }

        @Override
        public ExecutionResult assertSuccess() {
            if (this.exception != null) {
                throw new AssertionError(ExecutionResult.appendCommand(new StringBuilder("Build failed: "), this.args).toString(), this.exception);
            }
            if (this.exitCode != 0) {
                throw new AssertionError(ExecutionResult.appendCommand(new StringBuilder("Build exited with non-zero exit code " + this.exitCode + ": "), this.args).toString(), this.exception);
            }
            return this;
        }

        @Override
        public ExecutionResult assertFailure() {
            if (this.exception == null && this.exitCode == 0) {
                throw new AssertionError(ExecutionResult.appendCommand(new StringBuilder("Build did not fail: "), this.args));
            }
            return this;
        }

        @Override
        public int getExitCode() {
            return this.exitCode;
        }

        @Override
        public boolean isSuccess() {
            return this.exception == null;
        }
    }
}

