/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parameter;

import java.util.Objects;

public class ParameterDescriptor {
    private final String name;
    private final String description;
    private final boolean sensitive;

    private ParameterDescriptor(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.sensitive = builder.sensitive;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDescriptor other = (ParameterDescriptor)o;
        return Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private String name;
        private String description;
        private boolean sensitive;

        public Builder name(String name) {
            Objects.requireNonNull(name);
            this.name = name.trim();
            return this;
        }

        public Builder description(String description) {
            this.description = description == null ? null : description.trim();
            return this;
        }

        public Builder sensitive(boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        public Builder from(ParameterDescriptor descriptor) {
            this.name(descriptor.getName());
            this.description(descriptor.getDescription());
            this.sensitive(descriptor.isSensitive());
            return this;
        }

        public ParameterDescriptor build() {
            if (this.name == null) {
                throw new IllegalStateException("Must specify Parameter Name");
            }
            return new ParameterDescriptor(this);
        }
    }
}

