/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class DropDownAlignmentBehavior
extends BootstrapBaseBehavior {
    private static final long serialVersionUID = 1L;
    private static final String[] POSSIBLE_CLASSES = (String[])Stream.of(Size.values()).flatMap(size -> Stream.of(Alignment.left(size), Alignment.right(size))).map(Alignment::cssClassName).toArray(String[]::new);
    private final IModel<Collection<Alignment>> alignment;

    public DropDownAlignmentBehavior(IModel<Collection<Alignment>> alignment) {
        this.alignment = (IModel)Args.notNull(alignment, (String)"alignment");
    }

    public DropDownAlignmentBehavior(Alignment ... alignment) {
        this((IModel<Collection<Alignment>>)Model.of(List.of((Alignment[])Args.notNull((Object)alignment, (String)"alignment"))));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.removeClass(tag, POSSIBLE_CLASSES);
        ((Collection)this.alignment.getObject()).forEach(align -> Attributes.addClass(tag, align.cssClassName()));
    }

    public DropDownAlignmentBehavior setAlignment(Alignment ... alignment) {
        this.alignment.setObject(List.of(alignment));
        return this;
    }

    public void detach(Component component) {
        super.detach(component);
        this.alignment.detach();
    }

    public static class Alignment
    implements ICssClassNameProvider {
        private static final String CLASS_RIGHT = "end";
        private static final String CLASS_LEFT = "start";
        public static final Alignment RIGHT = Alignment.right();
        public static final Alignment NONE = new Alignment("");
        private final String className;
        private final Size size;

        private Alignment(String className) {
            this(className, Size.NONE);
        }

        private Alignment(String className, Size size) {
            Args.isTrue((Strings.isEmpty((String)className) || CLASS_LEFT.equals(className) || CLASS_RIGHT.equals(className) ? 1 : 0) != 0, (String)"className", (Object[])new Object[0]);
            this.className = className;
            this.size = size;
        }

        public static Alignment left() {
            return Alignment.left(Size.NONE);
        }

        public static Alignment left(Size size) {
            return new Alignment(CLASS_LEFT, size);
        }

        public static Alignment right() {
            return Alignment.right(Size.NONE);
        }

        public static Alignment right(Size size) {
            return new Alignment(CLASS_RIGHT, size);
        }

        @Override
        public String cssClassName() {
            if (Strings.isEmpty((String)this.className)) {
                return this.className;
            }
            String sizeCss = this.size.cssClassName() + (Strings.isEmpty((String)this.size.cssClassName()) ? "" : "-");
            return "dropdown-menu-" + sizeCss + this.className;
        }
    }

    public static enum Size implements ICssClassNameProvider
    {
        SMALL("sm"),
        MEDIUM("md"),
        LARGE("lg"),
        XLARGE("xl"),
        XXLARGE("xxl"),
        NONE("");

        private final String className;

        private Size(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

