/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import com.google.common.util.concurrent.RateLimiter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.ChannelHangupListener;
import org.asteriskjava.pbx.InvalidChannelName;
import org.asteriskjava.pbx.PBXFactory;
import org.asteriskjava.pbx.agi.ActivityArrivalListener;
import org.asteriskjava.pbx.agi.AgiChannelActivityHold;
import org.asteriskjava.pbx.agi.config.ServiceAgiScriptImpl;
import org.asteriskjava.pbx.asterisk.wrap.actions.OriginateAction;
import org.asteriskjava.pbx.internal.core.AsteriskPBX;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public abstract class ActivityAgi
extends ServiceAgiScriptImpl {
    public static final String ARRIVAL_KEY = "ActivityAgiArrivalKey";
    private static final Log logger = LogFactory.getLog(ActivityAgi.class);
    private static final Map<String, ActivityArrivalListener> arrivalListeners = new ConcurrentHashMap<String, ActivityArrivalListener>();

    public static AutoCloseable addArrivalListener(OriginateAction originate, ActivityArrivalListener listener) {
        final String key = UUID.randomUUID().toString();
        arrivalListeners.put(key, listener);
        if (arrivalListeners.size() > 100) {
            ActivityArrivalListener leaked = arrivalListeners.remove(arrivalListeners.keySet().iterator().next());
            logger.error("Arrival Listeners are leaking" + leaked.getClass().getCanonicalName());
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("_ActivityAgiArrivalKey", key);
        originate.setVariables(vars);
        return new AutoCloseable(){

            @Override
            public void close() throws Exception {
                arrivalListeners.remove(key);
            }
        };
    }

    @Override
    public void service() throws AgiException {
        Channel channelProxy = null;
        String channelName = this.channel.getName();
        try {
            ActivityArrivalListener listener;
            String arrivalKey;
            AsteriskPBX pbx = (AsteriskPBX)PBXFactory.getActivePBX();
            String proxyId = this.getVariable("proxyId");
            if (proxyId != null && proxyId.length() > 0) {
                channelProxy = pbx.getProxyById(proxyId);
            }
            if (channelProxy == null) {
                logger.info("'proxyId' var not set or proxy doesn't exist anymore, trying to match the channel name... " + channelName);
                channelProxy = pbx.internalRegisterChannel(this.channel.getName(), this.channel.getUniqueId());
            }
            logger.info("Channel " + channelName + " arrived in agi");
            channelProxy.setIsInAgi(true);
            channelProxy.addHangupListener(new ChannelHangupListener(){

                @Override
                public void channelHangup(Channel channel, Integer cause, String causeText) {
                    AgiChannelActivityAction currentActivityAction = channel.getCurrentActivityAction();
                    if (currentActivityAction != null) {
                        currentActivityAction.cancel();
                    }
                }
            });
            AgiChannelActivityAction action = channelProxy.getCurrentActivityAction();
            if (action == null) {
                action = new AgiChannelActivityHold();
            }
            if ((arrivalKey = this.channel.getVariable(ARRIVAL_KEY)) != null && arrivalKey.length() > 0 && (listener = arrivalListeners.get(arrivalKey)) != null) {
                listener.channelArrived(channelProxy);
            }
            boolean isAlive = true;
            RateLimiter slowRateLimiter = RateLimiter.create((double)2.0);
            while (!action.isDisconnect(this) && isAlive) {
                action.execute(this.channel, channelProxy);
                action = channelProxy.getCurrentActivityAction();
                logger.debug("Action for proxy " + channelProxy + " is " + action.getClass().getSimpleName());
                isAlive = this.checkChannelIsStillUp();
                slowRateLimiter.acquire();
            }
        }
        catch (AgiHangupException e) {
            logger.warn("Channel hungup " + channelName);
        }
        catch (InterruptedException | InvalidChannelName e) {
            logger.error(e, e);
        }
        logger.debug("Channel leaving agi " + channelName);
    }

    private boolean checkChannelIsStillUp() {
        try {
            this.answer();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

