/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.asteriskjava.lock.Lockable;
import org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent;
import org.asteriskjava.pbx.internal.core.FilteredManagerListener;
import org.asteriskjava.pbx.internal.core.FilteredManagerListenerWrapper;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class ListenerManager
extends Lockable {
    private final TreeSet<FilteredManagerListenerWrapper> listeners = new TreeSet<FilteredManagerListenerWrapper>(new ListenerPriorityComparator());
    Log logger = LogFactory.getLog(ListenerManager.class);

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public Iterator<FilteredManagerListenerWrapper> iterator() {
        return this.listeners.iterator();
    }

    public void addListener(FilteredManagerListener<ManagerEvent> listener) {
        this.listeners.add(new FilteredManagerListenerWrapper(listener));
    }

    List<FilteredManagerListenerWrapper> getCopyAsList() {
        LinkedList<FilteredManagerListenerWrapper> list = new LinkedList<FilteredManagerListenerWrapper>();
        for (FilteredManagerListenerWrapper listener : this.listeners) {
            list.add(listener);
        }
        return list;
    }

    boolean removeListener(FilteredManagerListener<ManagerEvent> toRemove) {
        boolean removed = false;
        Iterator<FilteredManagerListenerWrapper> itr = this.listeners.iterator();
        while (itr.hasNext()) {
            FilteredManagerListenerWrapper container = itr.next();
            if (container._listener != toRemove) continue;
            this.logger.debug("Removing listener " + toRemove);
            itr.remove();
            removed = true;
            break;
        }
        return removed;
    }

    final class ListenerPriorityComparator
    implements Comparator<FilteredManagerListenerWrapper> {
        ListenerPriorityComparator() {
        }

        @Override
        public int compare(FilteredManagerListenerWrapper lhs, FilteredManagerListenerWrapper rhs) {
            int result = lhs._listener.getPriority().compare(rhs._listener.getPriority());
            if (result == 0) {
                result = lhs.equalityBuster.compareTo(rhs.equalityBuster);
            }
            return result;
        }
    }
}

