/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

public class SocketOptions {
    public static final int KILO_BYTE = 1024;
    public static final int DEFAULT_BUFFER_SIZE_BYTE = 131072;
    static final int DEFAULT_BUFFER_SIZE_IN_KB = 128;
    static final int DEFAULT_LINGER_SECONDS = 3;
    private boolean tcpNoDelay = true;
    private boolean keepAlive = true;
    private boolean reuseAddress = true;
    private int lingerSeconds = 3;
    private int bufferSizeInKB = 128;

    public SocketOptions() {
    }

    public SocketOptions(SocketOptions socketOptions) {
        this.tcpNoDelay = socketOptions.tcpNoDelay;
        this.keepAlive = socketOptions.keepAlive;
        this.reuseAddress = socketOptions.reuseAddress;
        this.lingerSeconds = socketOptions.lingerSeconds;
        this.bufferSizeInKB = socketOptions.bufferSizeInKB;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public SocketOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public SocketOptions setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public SocketOptions setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this;
    }

    public int getLingerSeconds() {
        return this.lingerSeconds;
    }

    public SocketOptions setLingerSeconds(int lingerSeconds) {
        this.lingerSeconds = lingerSeconds;
        return this;
    }

    public int getBufferSize() {
        return this.bufferSizeInKB;
    }

    public SocketOptions setBufferSize(int bufferSize) {
        this.bufferSizeInKB = bufferSize;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketOptions that = (SocketOptions)o;
        if (this.tcpNoDelay != that.tcpNoDelay) {
            return false;
        }
        if (this.keepAlive != that.keepAlive) {
            return false;
        }
        if (this.reuseAddress != that.reuseAddress) {
            return false;
        }
        if (this.lingerSeconds != that.lingerSeconds) {
            return false;
        }
        return this.bufferSizeInKB == that.bufferSizeInKB;
    }

    public int hashCode() {
        int result = this.tcpNoDelay ? 1 : 0;
        result = 31 * result + (this.keepAlive ? 1 : 0);
        result = 31 * result + (this.reuseAddress ? 1 : 0);
        result = 31 * result + this.lingerSeconds;
        result = 31 * result + this.bufferSizeInKB;
        return result;
    }

    public String toString() {
        return "SocketOptions{tcpNoDelay=" + this.tcpNoDelay + ", keepAlive=" + this.keepAlive + ", reuseAddress=" + this.reuseAddress + ", lingerSeconds=" + this.lingerSeconds + ", bufferSizeInKB=" + this.bufferSizeInKB + "}";
    }
}

