/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.client.impl.protocol.util.PropertiesUtil;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.ringbuffer.RingbufferStore;
import com.hazelcast.ringbuffer.RingbufferStoreFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class RingbufferStoreConfig
implements IdentifiedDataSerializable {
    private boolean enabled = true;
    private String className;
    private String factoryClassName;
    private Properties properties;
    private RingbufferStore storeImplementation;
    private RingbufferStoreFactory factoryImplementation;

    public RingbufferStoreConfig() {
        this.properties = new Properties();
    }

    public RingbufferStoreConfig(RingbufferStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.storeImplementation = config.getStoreImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.properties = PropertiesUtil.clone(config.getProperties());
    }

    public RingbufferStore getStoreImplementation() {
        return this.storeImplementation;
    }

    public RingbufferStoreConfig setStoreImplementation(@Nonnull RingbufferStore storeImplementation) {
        this.storeImplementation = Preconditions.checkNotNull(storeImplementation, "Ringbuffer store cannot be null!");
        this.className = null;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RingbufferStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public RingbufferStoreConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Ringbuffer store class name must contain text");
        this.storeImplementation = null;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public RingbufferStoreConfig setProperties(Properties properties) {
        this.properties = Preconditions.checkNotNull(properties, "Ringbuffer store config properties cannot be null!");
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public RingbufferStoreConfig setProperty(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public RingbufferStoreConfig setFactoryClassName(@Nonnull String factoryClassName) {
        this.factoryClassName = Preconditions.checkHasText(factoryClassName, "Ringbuffer store factory class name must contain text");
        this.factoryImplementation = null;
        return this;
    }

    public RingbufferStoreFactory getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public RingbufferStoreConfig setFactoryImplementation(@Nonnull RingbufferStoreFactory factoryImplementation) {
        this.factoryImplementation = Preconditions.checkNotNull(factoryImplementation, "Ringbuffer store factory cannot be null");
        this.factoryClassName = null;
        return this;
    }

    public String toString() {
        return "RingbufferStoreConfig{enabled=" + this.enabled + ", className='" + this.className + "', storeImplementation=" + this.storeImplementation + ", factoryClassName='" + this.factoryClassName + "', factoryImplementation=" + this.factoryImplementation + ", properties=" + this.properties + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 35;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeString(this.className);
        out.writeString(this.factoryClassName);
        out.writeObject(this.properties);
        out.writeObject(this.storeImplementation);
        out.writeObject(this.factoryImplementation);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.className = in.readString();
        this.factoryClassName = in.readString();
        this.properties = (Properties)in.readObject();
        this.storeImplementation = (RingbufferStore)in.readObject();
        this.factoryImplementation = (RingbufferStoreFactory)in.readObject();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RingbufferStoreConfig)) {
            return false;
        }
        RingbufferStoreConfig that = (RingbufferStoreConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.storeImplementation, that.storeImplementation) && Objects.equals(this.className, that.className) && Objects.equals(this.properties, that.properties) && Objects.equals(this.factoryImplementation, that.factoryImplementation) && Objects.equals(this.factoryClassName, that.factoryClassName);
    }

    public final int hashCode() {
        return Objects.hash(this.enabled, this.properties, this.storeImplementation, this.className, this.factoryImplementation, this.factoryClassName);
    }
}

