/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.partition.strategy.AttributePartitioningStrategy;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.spi.impl.NodeEngine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PartitioningStrategyUtil {
    private static final PartitioningStrategy IDENTITY_PARTITIONING_STRATEGY = v -> v;

    private PartitioningStrategyUtil() {
    }

    public static Object constructAttributeBasedKey(Object[] keyAttributes) {
        return keyAttributes.length == 1 ? keyAttributes[0] : keyAttributes;
    }

    @Nullable
    public static Integer getPartitionIdFromKeyComponents(@Nonnull NodeEngine nodeEngine, @Nullable PartitioningStrategy<?> strategy, @Nonnull Object[] partitionKeyComponents) {
        assert (strategy == null || strategy instanceof DefaultPartitioningStrategy || strategy instanceof AttributePartitioningStrategy) : "Unsupported strategy";
        Object finalKey = PartitioningStrategyUtil.constructAttributeBasedKey(partitionKeyComponents);
        if (finalKey == null) {
            return null;
        }
        if (strategy instanceof AttributePartitioningStrategy) {
            Object keyData = nodeEngine.getSerializationService().toData(finalKey, IDENTITY_PARTITIONING_STRATEGY);
            return nodeEngine.getPartitionService().getPartitionId((Data)keyData);
        }
        return nodeEngine.getPartitionService().getPartitionId(finalKey);
    }
}

