/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataRestartNotificationRecipients is the corresponding interface of BACnetConstructedDataRestartNotificationRecipients
type BACnetConstructedDataRestartNotificationRecipients interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetRestartNotificationRecipients returns RestartNotificationRecipients (property field)
	GetRestartNotificationRecipients() []BACnetRecipient
	// IsBACnetConstructedDataRestartNotificationRecipients is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataRestartNotificationRecipients()
	// CreateBuilder creates a BACnetConstructedDataRestartNotificationRecipientsBuilder
	CreateBACnetConstructedDataRestartNotificationRecipientsBuilder() BACnetConstructedDataRestartNotificationRecipientsBuilder
}

// _BACnetConstructedDataRestartNotificationRecipients is the data-structure of this message
type _BACnetConstructedDataRestartNotificationRecipients struct {
	BACnetConstructedDataContract
	RestartNotificationRecipients []BACnetRecipient
}

var _ BACnetConstructedDataRestartNotificationRecipients = (*_BACnetConstructedDataRestartNotificationRecipients)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataRestartNotificationRecipients)(nil)

// NewBACnetConstructedDataRestartNotificationRecipients factory function for _BACnetConstructedDataRestartNotificationRecipients
func NewBACnetConstructedDataRestartNotificationRecipients(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, restartNotificationRecipients []BACnetRecipient, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataRestartNotificationRecipients {
	_result := &_BACnetConstructedDataRestartNotificationRecipients{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		RestartNotificationRecipients: restartNotificationRecipients,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataRestartNotificationRecipientsBuilder is a builder for BACnetConstructedDataRestartNotificationRecipients
type BACnetConstructedDataRestartNotificationRecipientsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(restartNotificationRecipients []BACnetRecipient) BACnetConstructedDataRestartNotificationRecipientsBuilder
	// WithRestartNotificationRecipients adds RestartNotificationRecipients (property field)
	WithRestartNotificationRecipients(...BACnetRecipient) BACnetConstructedDataRestartNotificationRecipientsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataRestartNotificationRecipients or returns an error if something is wrong
	Build() (BACnetConstructedDataRestartNotificationRecipients, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataRestartNotificationRecipients
}

// NewBACnetConstructedDataRestartNotificationRecipientsBuilder() creates a BACnetConstructedDataRestartNotificationRecipientsBuilder
func NewBACnetConstructedDataRestartNotificationRecipientsBuilder() BACnetConstructedDataRestartNotificationRecipientsBuilder {
	return &_BACnetConstructedDataRestartNotificationRecipientsBuilder{_BACnetConstructedDataRestartNotificationRecipients: new(_BACnetConstructedDataRestartNotificationRecipients)}
}

type _BACnetConstructedDataRestartNotificationRecipientsBuilder struct {
	*_BACnetConstructedDataRestartNotificationRecipients

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataRestartNotificationRecipientsBuilder) = (*_BACnetConstructedDataRestartNotificationRecipientsBuilder)(nil)

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataRestartNotificationRecipients
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) WithMandatoryFields(restartNotificationRecipients []BACnetRecipient) BACnetConstructedDataRestartNotificationRecipientsBuilder {
	return b.WithRestartNotificationRecipients(restartNotificationRecipients...)
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) WithRestartNotificationRecipients(restartNotificationRecipients ...BACnetRecipient) BACnetConstructedDataRestartNotificationRecipientsBuilder {
	b.RestartNotificationRecipients = restartNotificationRecipients
	return b
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) Build() (BACnetConstructedDataRestartNotificationRecipients, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataRestartNotificationRecipients.deepCopy(), nil
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) MustBuild() BACnetConstructedDataRestartNotificationRecipients {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataRestartNotificationRecipientsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataRestartNotificationRecipientsBuilder().(*_BACnetConstructedDataRestartNotificationRecipientsBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataRestartNotificationRecipientsBuilder creates a BACnetConstructedDataRestartNotificationRecipientsBuilder
func (b *_BACnetConstructedDataRestartNotificationRecipients) CreateBACnetConstructedDataRestartNotificationRecipientsBuilder() BACnetConstructedDataRestartNotificationRecipientsBuilder {
	if b == nil {
		return NewBACnetConstructedDataRestartNotificationRecipientsBuilder()
	}
	return &_BACnetConstructedDataRestartNotificationRecipientsBuilder{_BACnetConstructedDataRestartNotificationRecipients: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_RESTART_NOTIFICATION_RECIPIENTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetRestartNotificationRecipients() []BACnetRecipient {
	return m.RestartNotificationRecipients
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataRestartNotificationRecipients(structType any) BACnetConstructedDataRestartNotificationRecipients {
	if casted, ok := structType.(BACnetConstructedDataRestartNotificationRecipients); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataRestartNotificationRecipients); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetTypeName() string {
	return "BACnetConstructedDataRestartNotificationRecipients"
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.RestartNotificationRecipients) > 0 {
		for _, element := range m.RestartNotificationRecipients {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataRestartNotificationRecipients BACnetConstructedDataRestartNotificationRecipients, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataRestartNotificationRecipients"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataRestartNotificationRecipients")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	restartNotificationRecipients, err := ReadTerminatedArrayField[BACnetRecipient](ctx, "restartNotificationRecipients", ReadComplex[BACnetRecipient](BACnetRecipientParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'restartNotificationRecipients' field"))
	}
	m.RestartNotificationRecipients = restartNotificationRecipients

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataRestartNotificationRecipients"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataRestartNotificationRecipients")
	}

	return m, nil
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataRestartNotificationRecipients"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataRestartNotificationRecipients")
		}

		if err := WriteComplexTypeArrayField(ctx, "restartNotificationRecipients", m.GetRestartNotificationRecipients(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'restartNotificationRecipients' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataRestartNotificationRecipients"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataRestartNotificationRecipients")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) IsBACnetConstructedDataRestartNotificationRecipients() {
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) deepCopy() *_BACnetConstructedDataRestartNotificationRecipients {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataRestartNotificationRecipientsCopy := &_BACnetConstructedDataRestartNotificationRecipients{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetRecipient, BACnetRecipient](m.RestartNotificationRecipients),
	}
	_BACnetConstructedDataRestartNotificationRecipientsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataRestartNotificationRecipientsCopy
}

func (m *_BACnetConstructedDataRestartNotificationRecipients) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
