/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableQuantity {
  QuantityType_Symbol((int) 32476L),
  QuantityType_Annotation((int) 32478L),
  QuantityType_ConversionService((int) 32479L),
  QuantityType_Dimension((int) 32480L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol((int) 32483L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem((int) 32485L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline((int) 32486L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit((int) 32496L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol((int) 32498L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem((int) 32500L),
  QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline((int) 32501L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableQuantity> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableQuantity value : OpcuaNodeIdServicesVariableQuantity.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableQuantity(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableQuantity enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
