/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.metadata.internal.shared.NameToIdentifier;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.NameIterator;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.PropertiesConverter;
import org.apache.sis.referencing.SubTypes;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.ScopedIdentifier;
import org.apache.sis.xml.bind.UseLegacyMetadata;
import org.apache.sis.xml.bind.metadata.EX_Extent;
import org.apache.sis.xml.bind.referencing.Code;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

@XmlType(name="IdentifiedObjectType", propOrder={"descriptionGML", "identifier", "names", "remarks", "domainExtent", "domainScope"})
@XmlSeeAlso(value={AbstractCRS.class, AbstractDatum.class, DefaultEllipsoid.class, DefaultPrimeMeridian.class, AbstractCS.class})
@UseLegacyMetadata
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
Formattable,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final String LOCALE_KEY = "locale";
    public static final String DEPRECATED_KEY = "deprecated";
    public static final String DOMAINS_KEY = "domains";
    private ReferenceIdentifier name;
    private Collection<GenericName> alias;
    private Set<ReferenceIdentifier> identifiers;
    private Collection<DefaultObjectDomain> domains;
    @XmlElement(name="remarks")
    private InternationalString remarks;
    private final boolean deprecated;
    private transient int hashCode;

    public AbstractIdentifiedObject(Map<String, ?> properties) throws IllegalArgumentException {
        Object[] names;
        ArgumentChecks.ensureNonNull((String)"properties", properties);
        Object value = properties.get("name");
        if (value == null || value instanceof String) {
            if (value == null && properties.get("code") == null) {
                throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)111, (Object)"name"));
            }
            this.name = new NamedIdentifier(PropertiesConverter.convert(properties));
        } else if (value instanceof ReferenceIdentifier) {
            this.name = (ReferenceIdentifier)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "name", value);
        }
        value = properties.get("alias");
        try {
            DefaultNameFactory factory = DefaultNameFactory.provider();
            names = factory.toGenericNames(value);
        }
        catch (ClassCastException e) {
            throw (IllegalArgumentException)AbstractIdentifiedObject.illegalPropertyType(properties, "alias", value).initCause(e);
        }
        this.alias = CollectionsExt.immutableSet((boolean)true, (Object[])names);
        value = properties.get("identifiers");
        if (value instanceof ReferenceIdentifier) {
            this.identifiers = Collections.singleton((ReferenceIdentifier)value);
        } else if (value instanceof ReferenceIdentifier[]) {
            this.identifiers = CollectionsExt.immutableSet((boolean)true, (Object[])((ReferenceIdentifier[])value));
        } else if (value != null) {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, "identifiers", value);
        }
        value = properties.get(DOMAINS_KEY);
        if (value instanceof DefaultObjectDomain) {
            this.domains = Collections.singleton((DefaultObjectDomain)value);
        } else if (value instanceof DefaultObjectDomain[]) {
            this.domains = CollectionsExt.immutableSet((boolean)true, (Object[])((DefaultObjectDomain[])value));
        } else {
            if (value != null) {
                throw AbstractIdentifiedObject.illegalPropertyType(properties, DOMAINS_KEY, value);
            }
            InternationalString scope = Types.toInternationalString(properties, (String)"scope");
            Extent domainOfValidity = (Extent)Containers.property(properties, (Object)"domainOfValidity", Extent.class);
            if (scope != null || domainOfValidity != null) {
                this.domains = Collections.singleton(new DefaultObjectDomain(scope, domainOfValidity));
            }
        }
        this.remarks = Types.toInternationalString(properties, (String)"remarks");
        value = properties.get(DEPRECATED_KEY);
        if (value == null) {
            this.deprecated = false;
        } else if (value instanceof Boolean) {
            this.deprecated = (Boolean)value;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(properties, DEPRECATED_KEY, value);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> properties, String key, Object value) {
        return new IllegalArgumentException(Errors.forProperties(properties).getString((short)73, (Object)key, value.getClass()));
    }

    protected AbstractIdentifiedObject(IdentifiedObject object) {
        this.name = object.getName();
        if (this.name == null) {
            throw new IllegalArgumentException(Errors.format((short)111, (Object)"name"));
        }
        this.alias = CollectionsExt.nonEmpty((Collection)object.getAlias());
        this.identifiers = (Set)CollectionsExt.nonEmpty((Collection)object.getIdentifiers());
        this.domains = CollectionsExt.nonEmpty(Legacy.getDomains(object));
        this.remarks = object.getRemarks();
        this.deprecated = object instanceof Deprecable ? ((Deprecable)object).isDeprecated() : false;
    }

    public static AbstractIdentifiedObject castOrCopy(IdentifiedObject object) {
        return SubTypes.castOrCopy(object);
    }

    public Class<? extends IdentifiedObject> getInterface() {
        return IdentifiedObject.class;
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public Collection<GenericName> getAlias() {
        return CollectionsExt.nonNull(this.alias);
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        return CollectionsExt.nonNull(this.identifiers);
    }

    public Collection<DefaultObjectDomain> getDomains() {
        return CollectionsExt.nonNull(this.domains);
    }

    public Optional<InternationalString> getDescription() {
        ReferenceIdentifier name = this.getName();
        if (name instanceof ImmutableIdentifier) {
            return Optional.ofNullable(((ImmutableIdentifier)name).getDescription());
        }
        if (name instanceof DefaultIdentifier) {
            return Optional.ofNullable(((DefaultIdentifier)name).getDescription());
        }
        return Optional.empty();
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHeuristicMatchForName(String name) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)this.name, this.alias, (CharSequence)name, (NameToIdentifier.Simplifier)NameToIdentifier.Simplifier.DEFAULT);
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == null) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                int oc;
                int tc;
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AbstractIdentifiedObject that = (AbstractIdentifiedObject)object;
                if (mode == ComparisonMode.STRICT && (tc = this.hashCode) != 0 && (oc = that.hashCode) != 0 && tc != oc) {
                    return false;
                }
                return this.deprecated == that.deprecated && Objects.equals(this.name, that.name) && CollectionsExt.nonNull(this.alias).equals(CollectionsExt.nonNull(that.alias)) && CollectionsExt.nonNull(this.identifiers).equals(CollectionsExt.nonNull(that.identifiers)) && CollectionsExt.nonNull(this.domains).equals(CollectionsExt.nonNull(that.domains)) && Objects.equals(this.remarks, that.remarks);
            }
            case BY_CONTRACT: {
                if (!this.implementsSameInterface(object)) {
                    return false;
                }
                IdentifiedObject that = (IdentifiedObject)object;
                return Utilities.deepEquals((Object)this.getName(), (Object)that.getName(), (ComparisonMode)mode) && Utilities.deepEquals(this.getAlias(), (Object)that.getAlias(), (ComparisonMode)mode) && Utilities.deepEquals(this.getIdentifiers(), (Object)that.getIdentifiers(), (ComparisonMode)mode) && Utilities.deepEquals(this.getDomains(), Legacy.getDomains(that), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.getRemarks(), (Object)that.getRemarks(), (ComparisonMode)mode);
            }
        }
        return this.implementsSameInterface(object);
    }

    private boolean implementsSameInterface(Object object) {
        Class[] t;
        Class<? extends IdentifiedObject> type = this.getInterface();
        if (Projection.class.isAssignableFrom(type)) {
            type = Conversion.class;
        }
        if (object instanceof AbstractIdentifiedObject) {
            Class<? extends IdentifiedObject> other = ((AbstractIdentifiedObject)object).getInterface();
            if (Projection.class.isAssignableFrom(other)) {
                other = Conversion.class;
            }
            return other == type;
        }
        return type.isInstance(object) && (t = Classes.getLeafInterfaces(object.getClass(), type)).length == 1 && t[0] == type;
    }

    public final boolean equals(Object object) {
        boolean eq = this.equals(object, ComparisonMode.STRICT);
        assert (!eq || this.hashCode() == object.hashCode()) : this;
        return eq;
    }

    public final int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = Long.hashCode(this.computeHashCode());
            if (hash == 0) {
                hash = -1;
            }
            this.hashCode = hash;
        }
        assert (hash == -1 || hash == Long.hashCode(this.computeHashCode())) : hash;
        return hash;
    }

    protected long computeHashCode() {
        return Objects.hash(this.name, CollectionsExt.nonNull(this.alias), CollectionsExt.nonNull(this.identifiers), CollectionsExt.nonNull(this.domains), this.deprecated, this.remarks) ^ this.getInterface().hashCode();
    }

    @Override
    protected String formatTo(org.apache.sis.io.wkt.Formatter formatter) {
        WKTUtilities.appendName(this, formatter, ElementKind.forType(this.getClass()));
        return null;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String value = (flags & 4) != 0 ? IdentifiedObjects.getIdentifierOrName(this) : IdentifiedObjects.getDisplayName(this, formatter.locale());
        Strings.formatTo((Formatter)formatter, (int)flags, (int)width, (int)precision, (String)value);
    }

    AbstractIdentifiedObject() {
        this.deprecated = false;
    }

    @XmlID
    @XmlSchemaType(name="ID")
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml/3.2", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    final String getID() {
        return NameIterator.getID(this, this.name, this.alias, this.identifiers);
    }

    private void setID(String id) {
        NameIterator.setID(this, id);
    }

    @XmlElement(required=true)
    final Code getIdentifier() {
        return Code.forIdentifiedObject(this.getClass(), this.identifiers);
    }

    private void setIdentifier(Code identifier) {
        ReferenceIdentifier id;
        if (this.identifiers != null) {
            AbstractIdentifiedObject.propertyAlreadySet("setIdentifier", "identifier");
        } else if (identifier != null && (id = identifier.getIdentifier()) != null) {
            this.identifiers = Collections.singleton(id);
            ScopedIdentifier key = new ScopedIdentifier(this.getInterface(), identifier.toString());
            key.store(IdentifiedObject.class, (Object)this, AbstractIdentifiedObject.class, "setIdentifier");
            ScopedIdentifier scopedIdentifier = key;
            key = key.rename(identifier.code);
            if (scopedIdentifier != key) {
                key.store(IdentifiedObject.class, (Object)this, null, null);
            }
        }
    }

    @XmlElement(name="name", required=true)
    final Collection<ReferenceIdentifier> getNames() {
        return new Names();
    }

    @XmlElement(name="description")
    private InternationalString getDescriptionGML() {
        return this.getDescription().orElse(null);
    }

    private <T> T findFirst(Function<DefaultObjectDomain, T> getter) {
        if (this.domains == null) {
            return null;
        }
        return this.domains.stream().map(getter).filter(ImplementationHelper::nonNil).findFirst().orElse(null);
    }

    @XmlElement(name="domainOfValidity")
    @XmlJavaTypeAdapter(value=EX_Extent.class)
    private Extent getDomainExtent() {
        return this.findFirst(DefaultObjectDomain::getDomainOfValidity);
    }

    @XmlElement(name="scope")
    private InternationalString getDomainScope() {
        return this.findFirst(DefaultObjectDomain::getScope);
    }

    private void setDomainExtent(Extent value) {
        InternationalString scope = null;
        DefaultObjectDomain domain = (DefaultObjectDomain)CollectionsExt.first(this.domains);
        if (domain != null) {
            if (domain.domainOfValidity != null) {
                AbstractIdentifiedObject.propertyAlreadySet("setDomain", "domainOfValidity");
                return;
            }
            scope = domain.scope;
        }
        this.domains = Collections.singleton(new DefaultObjectDomain(scope, value));
    }

    private void setDomainScope(InternationalString value) {
        Extent area = null;
        DefaultObjectDomain domain = (DefaultObjectDomain)CollectionsExt.first(this.domains);
        if (domain != null) {
            if (domain.scope != null) {
                AbstractIdentifiedObject.propertyAlreadySet("setDomainScope", "scope");
                return;
            }
            area = domain.domainOfValidity;
        }
        this.domains = Collections.singleton(new DefaultObjectDomain(value, area));
    }

    private static void propertyAlreadySet(String method, String name) {
        ImplementationHelper.propertyAlreadySet(AbstractIdentifiedObject.class, (String)method, (String)name);
    }

    private final class Names
    extends AbstractCollection<ReferenceIdentifier> {
        private Names() {
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return NameIterator.count(AbstractIdentifiedObject.this);
        }

        @Override
        public Iterator<ReferenceIdentifier> iterator() {
            return new NameIterator(AbstractIdentifiedObject.this);
        }

        @Override
        public boolean add(ReferenceIdentifier id) {
            if (NameIterator.isUnnamed(AbstractIdentifiedObject.this.name)) {
                AbstractIdentifiedObject.this.name = id;
            } else {
                GenericName n;
                Object object = n = id instanceof GenericName ? (GenericName)id : new NamedIdentifier(id);
                if (AbstractIdentifiedObject.this.alias == null) {
                    AbstractIdentifiedObject.this.alias = Collections.singleton(n);
                } else {
                    int size = AbstractIdentifiedObject.this.alias.size();
                    Object[] names = AbstractIdentifiedObject.this.alias.toArray(new GenericName[size + 1]);
                    names[size] = n;
                    AbstractIdentifiedObject.this.alias = UnmodifiableArrayList.wrap((Object[])names);
                }
            }
            return true;
        }
    }
}

