/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.impl.override;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sling.caconfig.spi.ConfigurationOverrideProvider;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={ConfigurationOverrideProvider.class}, immediate=true)
@Designate(ocd=Config.class, factory=true)
public final class OsgiConfigurationOverrideProvider
implements ConfigurationOverrideProvider {
    private Collection<String> overrideStrings;

    @Activate
    void activate(Config config) {
        ArrayList<String> overrides = new ArrayList<String>();
        if (config.enabled()) {
            overrides.addAll(Arrays.asList(config.overrides()));
        }
        this.overrideStrings = overrides;
    }

    @NotNull
    public Collection<String> getOverrideStrings() {
        return this.overrideStrings;
    }

    @ObjectClassDefinition(name="Apache Sling Context-Aware Configuration Override Provider: OSGi configuration", description="Allows to override configuration property values from OSGi configurations.")
    public static @interface Config {
        @AttributeDefinition(name="Description", description="This description is used for display in the web console.")
        public String description();

        @AttributeDefinition(name="Overrides", description="Override strings - examples:\n{configName}/{propertyName}={propertyJsonValue}\n{configName}={propertyJsonObject}\n[{contextPath}]{configName}/{propertyName}={propertyJsonValue}\n[{contextPath}]{configName}={propertyJsonObject}")
        public String[] overrides();

        @AttributeDefinition(name="Enabled", description="Enable this override provider.")
        public boolean enabled() default false;

        @AttributeDefinition(name="Service Ranking", description="Priority of configuration override providers (higher = higher priority).")
        public int service_ranking() default 100;

        public String webconsole_configurationFactory_nameHint() default "{description}, enabled={enabled}";
    }
}

