/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ${package};

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HelloWorldModelTest {
    @Rule
    public final SlingContext context = new SlingContext();

    @Before
    public void init() {
        context.addModelsForPackage("${package}");
        context.load().json("/resource.json", "/content");
        context.currentResource("/content");
    }

    @Test
    public void testModel() {
        HelloWorldModel model = context.currentResource().adaptTo(HelloWorldModel.class);
        assertNotNull(model);
        assertEquals("Hello World!", model.getMessage());
    }
}
