/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.crankstart.extensions.sling;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@org.apache.felix.scr.annotations.Properties(value={@Property(name="felix.inventory.printer.name", value={"crankstart"}), @Property(name="felix.inventory.printer.title", value={"Sling Crankstart Exporter"}), @Property(name="felix.inventory.printer.format", value={"TEXT"})})
public class CrankstartInventoryPrinter
implements InventoryPrinter {
    private BundleContext bundleContext;
    private static final String INDENT = "  ";
    @Reference
    private StartLevel startLevel;
    private static final String[] PROPS_TO_IGNORE = new String[]{"service.pid", "service.factoryPid"};

    @Activate
    public void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
    }

    public void print(PrintWriter out, Format fmt, boolean isZip) {
        try {
            this.includeResource(out, "/crankstart-header.txt");
            this.header(out, "bundles");
            this.bundles(out);
            this.header(out, "configurations");
            this.configs(out);
            this.header(out, "end of " + this.getClass().getSimpleName() + " status dump");
        }
        catch (Exception e) {
            e.printStackTrace(out);
        }
    }

    private void configs(PrintWriter out) throws IOException {
        ServiceReference ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            out.println("WARN - ConfigurationAdmin service not available");
            return;
        }
        out.println("# The CRANKSTART_CONFIG_ID property that we add to configs is meant to detect which factory configs have already been created");
        ConfigurationAdmin ca = (ConfigurationAdmin)this.bundleContext.getService(ref);
        try {
            Configuration[] allCfg = ca.listConfigurations(null);
            int count = 0;
            if (allCfg != null) {
                for (Configuration cfg : allCfg) {
                    ++count;
                    if (cfg.getFactoryPid() != null && cfg.getFactoryPid().length() > 0) {
                        out.print("config.factory ");
                        out.print(cfg.getFactoryPid());
                    } else {
                        out.print("config ");
                        out.print(cfg.getPid());
                    }
                    out.println(" FORMAT:felix.config");
                    out.print(INDENT);
                    out.print("CRANKSTART_CONFIG_ID=\"");
                    out.print(UUID.randomUUID());
                    out.println("\"");
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ConfigurationHandler.write(bos, cfg.getProperties());
                    BufferedReader r = new BufferedReader(new StringReader(new String(bos.toString())));
                    String line = null;
                    block6: while ((line = r.readLine()) != null) {
                        for (String p : PROPS_TO_IGNORE) {
                            if (line.startsWith(p)) continue block6;
                        }
                        out.print(INDENT);
                        out.println(line);
                    }
                    out.println();
                }
            }
            out.print("# ");
            out.print(count);
            out.println(" configurations processed");
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException("Unexpected InvalidSyntaxException", ise);
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }

    private void bundles(PrintWriter out) throws IOException {
        for (int i = 1; i <= this.startLevel.getStartLevel(); ++i) {
            this.bundles(out, i);
        }
    }

    private void bundles(PrintWriter out, int level) throws IOException {
        List<String> coords;
        int ok = 0;
        int errors = 0;
        int warnings = 0;
        int count = 0;
        TreeSet<String> fragmentCoords = new TreeSet<String>();
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!CrankstartInventoryPrinter.isFragment(b)) continue;
            coords = this.getMavenCoordinates(b, null);
            if (coords.size() > 1) {
                ++warnings;
                this.multipleWarning(out, b, coords);
                continue;
            }
            fragmentCoords.add(coords.get(0));
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            if (this.startLevel.getBundleStartLevel(b) != level) continue;
            if (count == 0) {
                out.println();
                out.print("# bundles for start level ");
                out.println(level);
            }
            ++count;
            coords = this.getMavenCoordinates(b, fragmentCoords);
            if (coords.isEmpty()) {
                ++errors;
                out.print("# ERROR: Maven coordinates not found for ");
                out.print(CrankstartInventoryPrinter.getBundleInfo(b));
                out.println();
                continue;
            }
            if (coords.size() > 1) {
                ++warnings;
                this.multipleWarning(out, b, coords);
                continue;
            }
            ++ok;
            out.print("bundle ");
            out.println(coords.get(0));
        }
        if (count > 0) {
            out.println();
            out.print("# ");
            out.print("start level ");
            out.print(level);
            out.print(": ");
            out.print(ok);
            out.print(" bundles processed sucessfully, ");
            out.print(errors);
            out.print(" errors, ");
            out.print(warnings);
            out.print(" warnings.");
            out.println();
            out.println("start.all.bundles");
        }
    }

    private void multipleWarning(PrintWriter out, Bundle b, List<String> coords) {
        out.print("# WARN: multiple Maven coordinates for ");
        out.print(CrankstartInventoryPrinter.getBundleInfo(b));
        out.print(": ");
        out.print(coords);
        out.println();
    }

    private static boolean isFragment(Bundle bundle) {
        Dictionary headerMap = bundle.getHeaders();
        return headerMap.get("Fragment-Host") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMavenCoordinates(Bundle b, Collection<String> fragmentCoordinates) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration entries = b.findEntries("META-INF/maven", "pom.properties", true);
        while (entries != null && entries.hasMoreElements()) {
            URL u = (URL)entries.nextElement();
            Properties props = new Properties();
            InputStream is = null;
            try {
                is = u.openStream();
                props.load(is);
                StringBuilder thisBundle = new StringBuilder();
                thisBundle.append("mvn:").append(props.get("groupId")).append("/").append(props.get("artifactId")).append("/").append(props.get("version"));
                if (fragmentCoordinates != null && !CrankstartInventoryPrinter.isFragment(b) && fragmentCoordinates.contains(thisBundle.toString())) continue;
                result.add(thisBundle.toString());
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return result;
    }

    private static String getBundleInfo(Bundle b) {
        StringBuilder sb = new StringBuilder();
        sb.append("bundle ").append(b.getSymbolicName()).append(" ").append(b.getVersion()).append(" (").append(b.getBundleId()).append(")");
        return sb.toString();
    }

    private void header(PrintWriter out, String title) {
        out.println();
        out.print("# ");
        out.println(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeResource(PrintWriter out, String path) throws IOException {
        InputStream resource = this.getClass().getResourceAsStream(path);
        if (resource == null) {
            throw new IOException("Resource not found: " + path);
        }
        try {
            IOUtils.copy((InputStream)resource, (Writer)out);
        }
        finally {
            resource.close();
        }
    }

    protected void bindStartLevel(StartLevel startLevel) {
        this.startLevel = startLevel;
    }

    protected void unbindStartLevel(StartLevel startLevel) {
        if (this.startLevel == startLevel) {
            this.startLevel = null;
        }
    }
}

